set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9028689';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4424',
      '20112442',
      '43113430',
      '31110020',
      NULL,
      '42441133',
      '41244340',
      '14323433',
      '02020134',
      '00413343',
      '10441210',
      '34234242',
      NULL,
      '40342242',
      '20014242',
      '03043311',
      '12433021',
      NULL,
      '34231044',
      '12004010',
      NULL,
      NULL,
      '14300123',
      '23034240',
      '33110342',
      '32414333',
      '13341024',
      '22112203',
      '34442344',
      NULL,
      '22041032',
      '20343241',
      '04300340',
      '33101240',
      '22003013',
      '02430303',
      '34242120',
      '03012021',
      '01131002',
      '42231413',
      NULL,
      '22330332',
      '23233224',
      '32433234',
      '01042440',
      '',
      '',
      NULL,
      NULL,
      '3120312',
      2.090060,
      0,
      3,
      NULL,
      '444433',
      2.775767,
      ' 8-26-1983',
      ' 5-25-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.666322,
      46,
      5,
      14,
      10,
      18.425128,
      NULL,
      0,
      7.707773,
      30,
      20,
      12.215636,
      21,
      33.058891,
      7,
      28.609530,
      0.808485,
      91.398940,
      6.658211,
      NULL,
      82.852125,
      88.680432,
      13,
      172,
      93,
      129,
      '10-26-1983',
      NULL,
      40,
      22,
      11,
      176,
      NULL,
      NULL,
      3,
      2,
      1.667309,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.956030,
      NULL,
      0.462746,
      1.810513,
      NULL,
      0.435872,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      114.759041,
      92,
      63,
      85.337710,
      98.419827,
      54,
      97.199417,
      9.406048,
      4,
      42,
      7.949634,
      '11-27-1976',
      8.539253,
      1.568447,
      NULL,
      57.808490,
      NULL,
      NULL,
      5.705062,
      ' 8- 3-1991',
      NULL,
      4.207712,
      ' 8-29-1974',
      7.691964,
      12.931969,
      NULL,
      4.307552,
      17.061332,
      1.561404,
      NULL,
      11,
      NULL,
      107,
      1.872337,
      0.700237,
      2.783006,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      73.055195,
      NULL,
      34.904172,
      ' 9- 8-1992',
      NULL,
      14,
      '11-18-2003',
      4,
      35.698183,
      20.447629,
      8.959248,
      NULL,
      52.803406,
      NULL,
      66,
      ' 9-23-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      21.909516,
      81,
      NULL,
      NULL,
      127.548572,
      0,
      3,
      NULL,
      6,
      9.423643,
      NULL,
      0,
      1,
      24.899511,
      0.348960,
      0,
      73,
      1.829205,
      NULL,
      NULL,
      NULL,
      NULL,
      10.886047,
      NULL,
      21.361121,
      NULL,
      1.225197,
      NULL,
      NULL,
      1.241829,
      0.684127,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      20.747705,
      NULL,
      NULL,
      0.629152,
      0.959027,
      56.694458,
      0,
      NULL,
      0.620184,
      3,
      0,
      NULL,
      0.128576,
      NULL,
      0,
      2,
      NULL,
      NULL,
      4.094430,
      10.730622,
      NULL,
      NULL,
      NULL,
      NULL,
      15,
      8.231276,
      3,
      5,
      0,
      NULL,
      1,
      2,
      NULL,
      ' 7- 3-1974',
      ' 0-11-1983',
      '11-18-1978',
      '10-21-2000',
      NULL,
      NULL,
      ' 4-14-1978',
      NULL);
commit;
end;
/


