set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9431384';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0301',
      '33400244',
      '04311234',
      NULL,
      NULL,
      '41121043',
      '23013413',
      '20040203',
      '03300103',
      '24001430',
      '01003442',
      '40043444',
      '13030240',
      '30101244',
      '03312044',
      '32310111',
      '11413440',
      '20024100',
      NULL,
      '01211210',
      '41340314',
      '23332034',
      '33133000',
      '00023242',
      '43121231',
      '32224022',
      '20114403',
      '12311321',
      NULL,
      '12432234',
      '12201142',
      NULL,
      '13441421',
      NULL,
      '34444414',
      '11100331',
      NULL,
      '30143114',
      '41341434',
      '04000214',
      '31132233',
      '41041444',
      '42203334',
      '44011210',
      '13434334',
      NULL,
      '34',
      NULL,
      NULL,
      '2214042',
      1,
      1,
      1,
      NULL,
      '232420',
      2.900602,
      '11-18-1986',
      NULL,
      41,
      NULL,
      8,
      NULL,
      25,
      NULL,
      38,
      21.566646,
      22,
      NULL,
      22.764490,
      14,
      NULL,
      12.451157,
      32.427077,
      8,
      2.018866,
      13.329936,
      62.479786,
      NULL,
      NULL,
      3,
      76,
      14,
      1.162728,
      48.467516,
      174,
      NULL,
      156.978279,
      75.203063,
      4.880308,
      ' 8-27-2001',
      NULL,
      22.560794,
      3,
      19.453455,
      NULL,
      NULL,
      ' 4-27-1997',
      0.546957,
      NULL,
      NULL,
      0.480689,
      3.891691,
      2,
      1,
      2.543612,
      1.022712,
      1,
      0,
      0,
      0.988825,
      1.470298,
      0,
      1,
      1,
      0,
      1.981047,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      76.766381,
      10.065984,
      4.478004,
      6.123817,
      11,
      10,
      NULL,
      0,
      0,
      92,
      1,
      NULL,
      108,
      1.941566,
      1,
      85,
      NULL,
      NULL,
      NULL,
      ' 5-17-1976',
      97.061016,
      67.175086,
      0.723327,
      71.182656,
      NULL,
      42,
      6,
      4.311656,
      73.965800,
      15,
      20.765736,
      9.365921,
      '11-20-2000',
      NULL,
      20.901206,
      NULL,
      59.178409,
      3.034210,
      107,
      6,
      NULL,
      NULL,
      10,
      NULL,
      5,
      NULL,
      16,
      1,
      5,
      11.897754,
      0.429560,
      NULL,
      NULL,
      36,
      NULL,
      1,
      3,
      18.262849,
      NULL,
      0,
      1,
      1.465573,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      75,
      0.060812,
      ' 8-26-1992',
      NULL,
      NULL,
      NULL,
      43.144372,
      NULL,
      17.766254,
      NULL,
      13.854414,
      10.863502,
      ' 6- 0-2000',
      NULL,
      NULL,
      NULL,
      14.893190,
      1.504369,
      ' 4- 4-1985',
      NULL,
      NULL,
      NULL,
      2,
      2,
      9.419121,
      ' 3-26-1986',
      50,
      39.451469,
      50,
      ' 2-15-1989',
      0.265743,
      58.155005,
      ' 5- 4-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


