set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9434885';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '41124334',
      '21013000',
      '11132414',
      '30433304',
      '00114432',
      NULL,
      '20302240',
      '11004132',
      '40042000',
      NULL,
      NULL,
      '24343003',
      '44130111',
      NULL,
      '30241101',
      '24010230',
      '44122123',
      '12040242',
      '32402304',
      '20122001',
      NULL,
      '42240024',
      '03212214',
      '02002210',
      '13110230',
      '22232320',
      '14403411',
      '03410212',
      '32333001',
      '42320042',
      NULL,
      NULL,
      '10204424',
      NULL,
      NULL,
      '43223043',
      '00241043',
      '33331114',
      '13424412',
      '24304241',
      '30411040',
      '04442031',
      '34420104',
      NULL,
      '224',
      '03',
      NULL,
      NULL,
      '1134132',
      1.221542,
      0.138111,
      3,
      NULL,
      '401421',
      3.818625,
      ' 0-23-1989',
      ' 3-12-1994',
      NULL,
      NULL,
      2.309468,
      14.130390,
      5.583549,
      24.650751,
      38,
      21,
      7,
      9.541262,
      25,
      21,
      37.976974,
      11.692529,
      16,
      10,
      NULL,
      31.434122,
      41,
      NULL,
      29.967448,
      1,
      NULL,
      18,
      1.619373,
      88.495080,
      182,
      74.940741,
      208.072200,
      123,
      NULL,
      ' 8-11-1995',
      44.689347,
      NULL,
      13,
      NULL,
      179,
      207.604169,
      ' 8-29-1986',
      1.387798,
      1,
      0.574666,
      NULL,
      3.905135,
      NULL,
      0,
      1.017695,
      1,
      1,
      1.095876,
      0,
      0.741856,
      3.004174,
      2.865407,
      1.720489,
      3.284919,
      3.050902,
      0.472677,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-18-1995',
      NULL,
      13,
      8.711593,
      20,
      NULL,
      3,
      ' 9-10-1975',
      NULL,
      0,
      163.516488,
      1.122935,
      0,
      NULL,
      0.102381,
      3,
      95,
      NULL,
      NULL,
      NULL,
      ' 2-10-1996',
      NULL,
      33,
      37,
      16.560761,
      NULL,
      50.484132,
      70.192603,
      7,
      74.800964,
      NULL,
      NULL,
      10,
      ' 3-10-1993',
      24.002155,
      6.867644,
      7.468218,
      3,
      59,
      23.471440,
      3,
      ' 4-27-1981',
      8,
      16.481462,
      ' 8-19-2002',
      NULL,
      NULL,
      9.661511,
      1,
      16.612923,
      5.050960,
      1,
      NULL,
      1,
      154.115358,
      1.769936,
      0,
      10,
      NULL,
      NULL,
      0,
      NULL,
      0.841137,
      ' 1-19-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.380097,
      ' 2-21-1983',
      NULL,
      NULL,
      NULL,
      13,
      '10-24-1982',
      35.582373,
      ' 8- 4-2001',
      16,
      20,
      ' 5-10-1994',
      NULL,
      67,
      '10-10-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      8.853969,
      ' 5-15-1997',
      38.223793,
      NULL,
      6.382933,
      ' 6-15-1984',
      1.888125,
      18.668787,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


