set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9119792';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1112',
      '04121204',
      '00311022',
      '11422111',
      NULL,
      '34422333',
      '01430304',
      '03401203',
      '11203224',
      NULL,
      '34211403',
      '43231220',
      NULL,
      '33102121',
      '00013421',
      '31222242',
      NULL,
      '01303444',
      '02324342',
      '34000410',
      '20430232',
      '13032212',
      '40401443',
      NULL,
      '23224414',
      '04120142',
      '10223024',
      NULL,
      '33302221',
      NULL,
      NULL,
      '42303223',
      NULL,
      '33103212',
      '13342003',
      '34400001',
      '01120030',
      '43333433',
      '30411433',
      '33220044',
      NULL,
      '32310200',
      '10301232',
      '03110031',
      NULL,
      '032',
      '32',
      NULL,
      NULL,
      NULL,
      NULL,
      0.935051,
      1,
      NULL,
      '012433',
      NULL,
      ' 4-18-1993',
      ' 1-11-1977',
      21,
      NULL,
      10.235037,
      6,
      4.538179,
      NULL,
      56,
      22.411190,
      26.906359,
      4,
      4,
      23,
      32.178296,
      NULL,
      34.706469,
      12,
      NULL,
      8,
      53,
      NULL,
      43.676876,
      NULL,
      NULL,
      14,
      1,
      101.852132,
      NULL,
      82.703451,
      96,
      221.758994,
      NULL,
      ' 7-20-1986',
      45,
      17,
      13.207749,
      33,
      141,
      101.324935,
      ' 3- 4-1995',
      3.266810,
      3,
      2,
      2,
      2.566471,
      1,
      2,
      NULL,
      1.348534,
      NULL,
      0.805351,
      NULL,
      NULL,
      3.225747,
      0,
      NULL,
      0.699492,
      1,
      2.061222,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8- 5-2003',
      83,
      4.790431,
      11.029094,
      NULL,
      2,
      2,
      ' 2-11-1976',
      0,
      2,
      97,
      NULL,
      1.229089,
      11,
      1,
      1.654454,
      5,
      0,
      NULL,
      91,
      ' 1- 0-2000',
      41.629880,
      74,
      103,
      NULL,
      50.079258,
      48.327426,
      15,
      48,
      4.667338,
      12.445961,
      49,
      NULL,
      ' 2-17-1978',
      16,
      11.109357,
      0,
      17,
      51.008457,
      19,
      10.869727,
      ' 4-14-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.135706,
      NULL,
      4.808897,
      NULL,
      185,
      26.568319,
      ' 7-21-1978',
      51.853651,
      9,
      ' 5-17-1987',
      25.396412,
      ' 9-28-1984',
      2,
      ' 5-23-2000',
      NULL,
      14,
      ' 2-13-1998',
      28,
      NULL,
      ' 5- 1-1996',
      15,
      12.880885,
      ' 9- 2-1977',
      3.825290,
      22.288206,
      ' 1- 3-1989',
      0,
      3,
      8,
      ' 8- 1-1996',
      41.090200,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


