set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9119792';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3214',
      '11004421',
      '13411100',
      '03101132',
      NULL,
      '00111243',
      '20322333',
      '20220212',
      '24433432',
      NULL,
      NULL,
      NULL,
      '01032124',
      NULL,
      '01101430',
      NULL,
      NULL,
      '31020204',
      NULL,
      '34222020',
      '34304010',
      '33133131',
      '10303023',
      '30042343',
      NULL,
      NULL,
      NULL,
      '44121044',
      NULL,
      '42330323',
      '31403334',
      '31421444',
      '04131040',
      '20434434',
      '34124242',
      '32140021',
      '13233433',
      '44232340',
      '43341212',
      '11334021',
      '01341024',
      '03112332',
      NULL,
      NULL,
      '43243001',
      '210',
      '41',
      40,
      10.900230,
      NULL,
      3.848380,
      86,
      2,
      NULL,
      '024010',
      4,
      '10-16-1979',
      ' 4- 8-1991',
      8.134476,
      104,
      28.510921,
      NULL,
      6.705441,
      1,
      49,
      8,
      1.947783,
      14,
      49,
      23,
      NULL,
      24,
      NULL,
      7.422216,
      33.000681,
      19,
      90.362662,
      6.752614,
      22,
      14,
      5.923786,
      NULL,
      NULL,
      54,
      37,
      90.180063,
      58.513549,
      195,
      149.516601,
      ' 9-29-1998',
      56.374155,
      7.723412,
      33.314712,
      39.118095,
      86,
      178.768205,
      ' 2- 6-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      67,
      NULL,
      NULL,
      NULL,
      6.767364,
      11,
      ' 0- 5-1993',
      0,
      0,
      NULL,
      0.369661,
      1.938358,
      89.508651,
      1.292471,
      1,
      54,
      NULL,
      NULL,
      NULL,
      ' 6-15-1995',
      2.842198,
      51,
      NULL,
      NULL,
      30.788123,
      7,
      NULL,
      63,
      67.305531,
      55,
      15,
      17.338840,
      NULL,
      NULL,
      5.134219,
      13,
      56.477536,
      0.216784,
      31.317721,
      NULL,
      NULL,
      1,
      7,
      NULL,
      1,
      15,
      8.874552,
      NULL,
      3.266678,
      13.577103,
      1.425052,
      10.617423,
      0.814608,
      82.278970,
      1,
      0.247481,
      12.651100,
      15,
      0,
      8,
      1,
      0,
      ' 3- 6-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      260.901885,
      8.197926,
      NULL,
      NULL,
      NULL,
      NULL,
      39,
      ' 5-16-1993',
      2.934657,
      ' 2-10-1995',
      NULL,
      2.436712,
      ' 7-22-2000',
      91.761467,
      22.545340,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      9.638938,
      ' 8-25-1992',
      3,
      42.320471,
      22,
      ' 0-24-1990',
      1.969271,
      14,
      ' 4-22-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


