set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6310169';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2142',
      '11340423',
      '33403134',
      '42013324',
      NULL,
      '11212113',
      '24142311',
      '03304444',
      NULL,
      '30442004',
      NULL,
      '33042010',
      '21042312',
      NULL,
      '43213123',
      NULL,
      '01430121',
      '34130022',
      '10243402',
      '00431401',
      NULL,
      '32321323',
      '02301101',
      NULL,
      '32442210',
      NULL,
      '33321103',
      '24332310',
      '31112020',
      '12321424',
      '43443134',
      '01440133',
      '04334230',
      '00143031',
      '11000234',
      '22043422',
      '12401414',
      '21343223',
      '32030421',
      '34014033',
      '01302041',
      '33122222',
      '40401142',
      '31034412',
      '32244133',
      '',
      '',
      NULL,
      NULL,
      '4203432',
      2.903776,
      NULL,
      0,
      NULL,
      '134124',
      2.571323,
      ' 1- 6-1983',
      ' 9-14-1998',
      53,
      NULL,
      19.577446,
      1.436216,
      17,
      3,
      77,
      15.329961,
      23,
      19,
      43.402931,
      8,
      43.161452,
      16,
      NULL,
      6,
      22.998336,
      10.463483,
      NULL,
      4,
      NULL,
      2,
      92,
      NULL,
      NULL,
      59,
      4,
      22.848810,
      88.776044,
      63,
      1.977843,
      ' 4-17-1979',
      NULL,
      NULL,
      0,
      11.920443,
      127.543729,
      NULL,
      '11- 3-1975',
      NULL,
      5.496876,
      0.723598,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.517713,
      0.842654,
      5,
      0,
      0.849987,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-14-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 9-2001',
      113,
      NULL,
      72,
      5,
      15.754691,
      64,
      68.112522,
      59.489546,
      NULL,
      51.773776,
      NULL,
      86,
      ' 7- 5-2003',
      21,
      30.607732,
      1,
      114.375331,
      NULL,
      NULL,
      4.609803,
      ' 1-15-1996',
      NULL,
      9.089737,
      ' 5- 7-1977',
      NULL,
      NULL,
      10.265174,
      4.383378,
      3.618275,
      1.680945,
      NULL,
      NULL,
      NULL,
      20.548657,
      9.590455,
      3,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-22-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.163482,
      29.714703,
      33.726620,
      ' 7-12-1998',
      0.441495,
      NULL,
      ' 0-16-1999',
      17,
      6,
      20.479156,
      14,
      ' 0- 0-1982',
      68.128297,
      1,
      33.474641,
      ' 2-28-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      21,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14.437379,
      0.903200,
      11.314913,
      5,
      NULL,
      0,
      1,
      NULL,
      0,
      1.211888,
      NULL,
      1,
      2,
      49.368957,
      1,
      NULL,
      172.992139,
      NULL,
      26,
      NULL,
      1.571512,
      NULL,
      1.280058,
      0.101162,
      1,
      1.240177,
      0.823043,
      NULL,
      NULL,
      NULL,
      NULL,
      7.749928,
      NULL,
      NULL,
      NULL,
      0.002481,
      7,
      NULL,
      6,
      2,
      17,
      0.924192,
      NULL,
      0.126541,
      NULL,
      NULL,
      1,
      NULL,
      19,
      NULL,
      1,
      NULL,
      NULL,
      11,
      NULL,
      7,
      NULL,
      0,
      NULL,
      0,
      0.215075,
      NULL,
      NULL,
      NULL,
      ' 8-16-1974',
      ' 2-18-1983',
      ' 6-10-1975',
      ' 9-28-2000',
      ' 4-24-1993',
      NULL,
      ' 9-13-1986',
      NULL);
commit;
end;
/


