set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9635002';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '42214111',
      '31444023',
      NULL,
      '30413022',
      '01020432',
      NULL,
      '40331004',
      '43401301',
      '34112123',
      '11303030',
      '33420030',
      '03132032',
      '22232042',
      '10000434',
      '04324123',
      NULL,
      '12320331',
      NULL,
      '40443234',
      '42410044',
      '24334002',
      NULL,
      '03022210',
      '44233403',
      '01111433',
      '40423101',
      '40210142',
      '31241100',
      NULL,
      '22324302',
      '21443202',
      '10441101',
      '30124323',
      '33000322',
      '32411131',
      '41004220',
      '03010213',
      '20234244',
      NULL,
      '11100200',
      '12112013',
      '20203312',
      '10240111',
      '14034241',
      '224',
      '22',
      NULL,
      25,
      '3324030',
      1.173116,
      0.554731,
      0,
      NULL,
      '410321',
      3,
      ' 9- 5-1981',
      NULL,
      48,
      NULL,
      NULL,
      8,
      NULL,
      12,
      55.343080,
      21,
      25.198532,
      12.434607,
      11,
      NULL,
      1,
      10,
      8,
      18.222071,
      3,
      12,
      23.120736,
      7,
      11,
      27.218269,
      41.631965,
      20,
      NULL,
      20.989658,
      6.527522,
      16.562372,
      222.421956,
      NULL,
      194.656955,
      ' 3- 7-1989',
      NULL,
      29.768138,
      13,
      19,
      157.431371,
      117,
      ' 8-10-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      30,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0.371396,
      NULL,
      147.944807,
      1.366662,
      0.820049,
      52,
      0.078668,
      1.395638,
      89.786989,
      NULL,
      NULL,
      NULL,
      ' 7- 3-2000',
      137,
      NULL,
      NULL,
      24,
      72,
      86,
      NULL,
      17,
      44.819863,
      71.251178,
      54.612604,
      0.600659,
      ' 1-26-1976',
      14.431121,
      NULL,
      18,
      7,
      9,
      0.821863,
      NULL,
      ' 0- 3-1975',
      NULL,
      8,
      ' 9-26-1992',
      11,
      0,
      0,
      4,
      2,
      3,
      1.245166,
      NULL,
      1,
      46.573247,
      0,
      1,
      0.394237,
      NULL,
      NULL,
      0,
      1.907197,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      125.143156,
      0.774983,
      '10- 7-1991',
      NULL,
      NULL,
      NULL,
      43.262899,
      NULL,
      24,
      ' 2- 1-1981',
      9.019851,
      10,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      15.831380,
      ' 6- 3-1988',
      59,
      24.891902,
      36,
      ' 8- 9-1999',
      0,
      116,
      ' 3- 4-1993',
      12.859962,
      17.593008,
      5.008414,
      9,
      '11-23-1975',
      NULL,
      1,
      28.675719,
      ' 3-23-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


