set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9635002';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      NULL,
      '0',
      '3',
      '1',
      '1',
      '3',
      '0',
      '2',
      '3',
      NULL,
      '3',
      '1',
      NULL,
      '0',
      NULL,
      '0',
      '0',
      '4',
      '4',
      '3',
      NULL,
      '1',
      '1',
      '',
      '2',
      NULL,
      '2',
      '0',
      NULL,
      NULL,
      '4',
      '',
      '',
      '4',
      '0',
      '3',
      '4',
      '2',
      '4',
      '0',
      '0',
      '3',
      '0',
      '2',
      '014',
      NULL,
      NULL,
      79,
      '3340423',
      1,
      15,
      NULL,
      0,
      NULL,
      NULL,
      ' 1-18-1984',
      NULL,
      26.440532,
      86.749014,
      28,
      3.001057,
      1,
      20,
      114,
      7.943157,
      NULL,
      22,
      NULL,
      28.167468,
      10.807869,
      2,
      25,
      NULL,
      10,
      NULL,
      15.206204,
      26,
      65.134038,
      28,
      126.008036,
      NULL,
      0.964900,
      NULL,
      215.151352,
      87,
      138,
      268.124347,
      NULL,
      ' 5-12-1990',
      52.785281,
      52.817807,
      32.569669,
      8.904662,
      118,
      60,
      ' 1- 3-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      25.273593,
      NULL,
      15.641063,
      3,
      7,
      1,
      ' 6- 4-1996',
      0,
      0.749732,
      152,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-28-1977',
      NULL,
      NULL,
      120.622585,
      NULL,
      65,
      139,
      63,
      33.618397,
      NULL,
      40.496410,
      NULL,
      21,
      ' 8- 3-1974',
      10,
      24,
      21,
      46.602017,
      NULL,
      138,
      10.896404,
      ' 2-17-1993',
      18,
      25,
      ' 6-19-1995',
      10.018805,
      12,
      19.694054,
      NULL,
      NULL,
      11,
      0,
      NULL,
      NULL,
      56.421134,
      NULL,
      1,
      4.357677,
      6.181411,
      1.921877,
      5.559643,
      NULL,
      3,
      ' 7-23-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      67.612433,
      0,
      ' 9-11-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      15.160173,
      ' 7-16-2001',
      56.139992,
      11.064249,
      48,
      ' 3-23-1991',
      1.397128,
      97.660586,
      NULL,
      1.501372,
      NULL,
      18,
      32.320658,
      ' 9-22-1988',
      34.753244,
      NULL,
      136,
      '11-25-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


