set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9130391';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '23123324',
      '30044413',
      '21303404',
      NULL,
      '01023321',
      NULL,
      '24430000',
      '30142200',
      '42142444',
      '02314040',
      '44113243',
      NULL,
      '24000113',
      '04213131',
      '40221042',
      '43142341',
      '01243420',
      '21114122',
      '40414213',
      '20131223',
      '00143021',
      '31100232',
      NULL,
      '03411102',
      '40330204',
      '21441144',
      '13321111',
      '30332014',
      '31134443',
      NULL,
      '04431010',
      '01212114',
      NULL,
      '21401430',
      NULL,
      NULL,
      '10141432',
      NULL,
      '40242110',
      '43343224',
      '41314143',
      '22211331',
      '02423132',
      '14241432',
      '311',
      '44',
      NULL,
      NULL,
      '1011012',
      1,
      0.269191,
      1,
      NULL,
      NULL,
      0.829536,
      NULL,
      ' 5-29-1978',
      88.141407,
      NULL,
      9,
      4,
      5,
      1,
      12.395846,
      1.408873,
      NULL,
      6.766396,
      10,
      5,
      3.382031,
      3.730637,
      1,
      4,
      5.218516,
      1.655848,
      29.860381,
      11,
      26,
      2.932969,
      55.362478,
      2.780898,
      0,
      20,
      15.670849,
      34.018080,
      84.794326,
      74,
      69.847888,
      ' 7-24-1998',
      33.866774,
      5.220787,
      NULL,
      2.793793,
      NULL,
      53,
      NULL,
      0.156018,
      0.529411,
      1.199735,
      1,
      NULL,
      3,
      NULL,
      3.366393,
      0.845004,
      NULL,
      1.067331,
      0,
      NULL,
      4,
      1,
      1.071238,
      2,
      1.992313,
      0,
      2.434474,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8- 7-1983',
      9.278763,
      19.076143,
      38.659232,
      7.452446,
      37.615073,
      NULL,
      ' 4-15-1993',
      4,
      1,
      72.646675,
      0,
      NULL,
      110.107871,
      9.731921,
      0,
      2.187530,
      NULL,
      NULL,
      NULL,
      ' 9-16-1983',
      24,
      39,
      23.097311,
      57,
      1,
      10.106400,
      4,
      41.643365,
      30.103343,
      NULL,
      4.355873,
      20,
      ' 9-27-2001',
      9.535599,
      5.588238,
      19.134099,
      32,
      19.714190,
      NULL,
      8.842580,
      ' 1- 5-1987',
      4,
      2,
      '10-22-1989',
      2,
      9,
      0,
      5.911714,
      5.868872,
      0,
      0,
      3,
      0,
      24.356283,
      1,
      0,
      1.551443,
      3,
      18,
      5,
      5.234794,
      1.497842,
      ' 8-18-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      23,
      NULL,
      37,
      ' 8-20-1999',
      NULL,
      NULL,
      NULL,
      45,
      18.196691,
      ' 5-24-1984',
      NULL,
      4,
      ' 1-11-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      8.612274,
      ' 9-12-1988',
      48.306070,
      2.685790,
      NULL,
      ' 7-19-1985',
      4,
      309.517923,
      ' 0- 0-1975',
      0.604264,
      86.821517,
      NULL,
      NULL,
      ' 3-26-1983',
      NULL,
      1.125253,
      44,
      ' 7-21-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


