set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9130391';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '20310203',
      '43431224',
      '30031302',
      '14030402',
      '14143301',
      '32222220',
      '42433314',
      NULL,
      '21420100',
      '41033430',
      NULL,
      '20413242',
      '10314432',
      '12432422',
      '22301133',
      '43031433',
      '00302123',
      '03224014',
      '43243020',
      '33334020',
      '20131221',
      '44312340',
      '02143014',
      NULL,
      '30341004',
      '23143240',
      '00233342',
      '00413010',
      '00003220',
      '14233133',
      '31030414',
      NULL,
      '31022441',
      '24223023',
      '30000311',
      NULL,
      '11142100',
      '01303443',
      '22122213',
      '20122302',
      '23141313',
      '12024431',
      '02443121',
      '44340241',
      '241',
      '24',
      3.969635,
      7,
      NULL,
      0,
      NULL,
      1,
      NULL,
      '012421',
      NULL,
      ' 4-24-1991',
      ' 5- 2-1982',
      78.855668,
      29.927132,
      17.982733,
      10,
      9,
      NULL,
      25.241059,
      4,
      0,
      2.198906,
      NULL,
      3.620648,
      18,
      2.350088,
      10.976291,
      NULL,
      7.382202,
      9,
      14,
      0,
      56,
      1,
      7,
      4,
      NULL,
      29,
      0.495036,
      NULL,
      123,
      41.413363,
      NULL,
      NULL,
      42.563225,
      15,
      15,
      0,
      24.742474,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      22,
      15.241527,
      36,
      NULL,
      13,
      NULL,
      NULL,
      0.422595,
      2,
      16,
      5.904144,
      6,
      21.671173,
      2.720953,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-28-1996',
      24,
      75.609005,
      29.119589,
      64,
      11.248997,
      NULL,
      58,
      39.945846,
      34.797244,
      39,
      11,
      NULL,
      NULL,
      7,
      38,
      32,
      62,
      34.278081,
      NULL,
      NULL,
      NULL,
      7,
      0.034080,
      '10-21-1989',
      NULL,
      3.654701,
      NULL,
      3.837086,
      3,
      2,
      1.565211,
      16,
      0,
      NULL,
      NULL,
      1,
      1.841188,
      26.679236,
      5,
      7.580036,
      NULL,
      4.239649,
      ' 1-15-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      54.446920,
      3,
      '10-17-1975',
      NULL,
      NULL,
      NULL,
      41.273496,
      ' 9- 7-1982',
      7,
      '11- 1-1994',
      6.017618,
      14.548163,
      ' 3-16-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1.489361,
      ' 2-23-1986',
      30,
      NULL,
      14,
      ' 4-29-1975',
      0.156308,
      122.573404,
      ' 0-26-1998',
      NULL,
      NULL,
      NULL,
      37,
      '10-12-1991',
      29,
      1,
      28,
      ' 8-29-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


