set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9130391';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '4',
      '0',
      '4',
      '4',
      NULL,
      '1',
      NULL,
      NULL,
      '1',
      NULL,
      '0',
      '1',
      '1',
      NULL,
      '3',
      '2',
      '3',
      '1',
      NULL,
      '2',
      '1',
      NULL,
      '0',
      '',
      '1',
      NULL,
      '2',
      '1',
      '3',
      '0',
      '3',
      '',
      '',
      '3',
      NULL,
      '3',
      '2',
      '4',
      '3',
      NULL,
      '2',
      '0',
      NULL,
      '1',
      '334',
      '34041143',
      11.289633,
      NULL,
      NULL,
      0.870475,
      20.732049,
      NULL,
      NULL,
      '311032',
      3,
      ' 8-10-1998',
      '10-23-2002',
      79,
      NULL,
      11,
      6,
      2,
      2,
      23.247231,
      2.927514,
      NULL,
      5,
      12.498054,
      7,
      26.609933,
      7,
      22,
      NULL,
      0,
      0,
      29.731303,
      11,
      NULL,
      11,
      104.394415,
      4.453911,
      0,
      NULL,
      2.234064,
      11.718620,
      34.527868,
      63,
      NULL,
      NULL,
      15.213225,
      8,
      NULL,
      1.820858,
      143,
      127.736707,
      ' 4-29-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      34,
      5.011038,
      4,
      22.174981,
      0.893120,
      NULL,
      1,
      0.634137,
      83,
      NULL,
      1.997262,
      88.931903,
      5,
      0,
      25.154191,
      NULL,
      NULL,
      NULL,
      NULL,
      15,
      75,
      45,
      40,
      66.063375,
      9.401886,
      NULL,
      NULL,
      27.002677,
      51,
      28.960724,
      9,
      ' 8- 5-1976',
      31.304458,
      32,
      NULL,
      NULL,
      10.239621,
      165.854343,
      10,
      NULL,
      3.461629,
      1,
      ' 3-23-1996',
      NULL,
      2,
      0,
      2.216589,
      3,
      7.113194,
      1,
      NULL,
      NULL,
      12.956618,
      2,
      NULL,
      3.339606,
      6.940017,
      3,
      11,
      0,
      1.145143,
      ' 1- 5-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      83,
      6.577068,
      NULL,
      NULL,
      NULL,
      NULL,
      19,
      ' 2-24-1975',
      NULL,
      ' 1- 0-1984',
      13,
      5,
      ' 8- 5-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      7,
      ' 2-19-1991',
      NULL,
      6.770590,
      16,
      '11-21-2002',
      5,
      58.160370,
      NULL,
      1,
      52.520583,
      19,
      7,
      ' 5-29-1980',
      23,
      1.231981,
      2.484230,
      ' 4-24-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


