set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9130391';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      NULL,
      '1',
      '4',
      '4',
      NULL,
      NULL,
      '2',
      '1',
      '3',
      '0',
      '0',
      '0',
      '2',
      NULL,
      '1',
      '3',
      '3',
      '0',
      NULL,
      '3',
      '1',
      '1',
      '3',
      NULL,
      NULL,
      '',
      '3',
      '3',
      '1',
      '0',
      '0',
      NULL,
      '',
      '3',
      '1',
      '2',
      NULL,
      '3',
      '0',
      '2',
      '0',
      '1',
      '0',
      '1',
      NULL,
      '20001204',
      34.434532,
      NULL,
      NULL,
      NULL,
      44.707391,
      0,
      0,
      '144233',
      5.095596,
      NULL,
      ' 1- 6-1990',
      107.305545,
      28.824471,
      24,
      9,
      NULL,
      NULL,
      46.377004,
      0.071932,
      0.163662,
      12,
      2.456075,
      NULL,
      NULL,
      4.951833,
      NULL,
      7.287418,
      NULL,
      5.358244,
      8,
      NULL,
      0.452918,
      7,
      23,
      10,
      NULL,
      NULL,
      24,
      64.103065,
      84.027714,
      127.097686,
      0.451450,
      '11-16-1978',
      10,
      15,
      5,
      NULL,
      102,
      4,
      ' 1-17-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      36.015019,
      44.300465,
      0.204373,
      12.704221,
      NULL,
      NULL,
      ' 4- 5-1979',
      1.210955,
      0.153626,
      38.058707,
      1,
      1,
      12.283263,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      56.495789,
      55.829167,
      87.013427,
      31,
      NULL,
      NULL,
      16.595835,
      77,
      22.819973,
      53,
      75,
      ' 7- 8-1999',
      19.941438,
      6.776703,
      NULL,
      27.390388,
      25.797906,
      61,
      1,
      NULL,
      4,
      5,
      ' 8-17-1996',
      2,
      NULL,
      3,
      2.184434,
      4.653677,
      3,
      0,
      NULL,
      NULL,
      51,
      0.385146,
      1.410580,
      NULL,
      27.073595,
      2,
      1,
      NULL,
      NULL,
      ' 7- 2-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      98,
      101.476072,
      ' 6- 4-1989',
      NULL,
      NULL,
      NULL,
      26,
      NULL,
      NULL,
      NULL,
      11.442441,
      2.123504,
      ' 0-23-1988',
      18,
      34,
      ' 3-20-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      21,
      ' 2- 2-1977',
      18,
      21.278339,
      3,
      NULL,
      NULL,
      NULL,
      '10- 7-1990',
      2.505995,
      100,
      NULL,
      23.258470,
      NULL,
      23,
      NULL,
      20,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


