set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9034332';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '32130001',
      '03310224',
      '02242403',
      '30320424',
      '10040403',
      NULL,
      '30303114',
      NULL,
      '23444403',
      '11321111',
      '24330443',
      NULL,
      '01332220',
      '11123140',
      NULL,
      '34224210',
      '31042230',
      '34424044',
      NULL,
      '02243213',
      '00442330',
      NULL,
      '42301233',
      '22442341',
      '21102022',
      '33320402',
      '33102422',
      '14211222',
      '20424323',
      '31101214',
      '13304300',
      '03113123',
      '21140144',
      '30414400',
      '40321140',
      '03103100',
      '31433234',
      '41232043',
      '30423324',
      '43220432',
      '10344444',
      '01110134',
      '03212101',
      '04130400',
      NULL,
      '20',
      NULL,
      NULL,
      '0442220',
      NULL,
      NULL,
      3,
      NULL,
      '111222',
      3,
      ' 0- 3-1978',
      ' 8-11-2001',
      24.857554,
      NULL,
      10.405176,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      5,
      9.633483,
      15,
      16.058726,
      26.159817,
      1.513134,
      31,
      9,
      NULL,
      4.407271,
      43.836914,
      3.954781,
      41.495230,
      2,
      24,
      15.881165,
      NULL,
      NULL,
      NULL,
      37,
      133.950255,
      NULL,
      154,
      ' 6-12-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.548419,
      0.181058,
      NULL,
      0.580718,
      3,
      0,
      0.310099,
      1.395137,
      1,
      3.850564,
      0,
      0,
      0,
      NULL,
      1.086250,
      2,
      NULL,
      0,
      1.389152,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      78.518621,
      9,
      23,
      19.298934,
      19.232638,
      6.228819,
      ' 1- 3-1984',
      NULL,
      0,
      37,
      NULL,
      0.531261,
      52,
      0,
      0,
      41,
      0,
      0,
      112,
      ' 4-29-1986',
      96.461012,
      68,
      NULL,
      63,
      43,
      75,
      67.397854,
      NULL,
      1.786740,
      69,
      82.395716,
      44.487596,
      '10-12-1980',
      42,
      21.424862,
      22,
      121.599984,
      98,
      70.446165,
      13,
      ' 4-29-1991',
      19,
      17,
      NULL,
      6,
      NULL,
      23,
      24,
      29.858788,
      6.675107,
      0.124107,
      16,
      1.804702,
      NULL,
      0.791394,
      16.674911,
      10.165548,
      6.190951,
      1.257767,
      0,
      1,
      0,
      NULL,
      3.188635,
      NULL,
      NULL,
      ' 0- 3-1994',
      112,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-15-1979',
      3.513749,
      ' 0- 5-1976',
      16,
      4.888669,
      ' 1-16-1990',
      NULL,
      5.141127,
      ' 9-19-1991',
      8,
      0.379854,
      ' 3-25-1993',
      NULL,
      4,
      ' 3-17-1984',
      0,
      3,
      24.487131,
      ' 0-12-1991',
      7,
      35,
      3.961814,
      ' 3-14-1979',
      1.965697,
      52.030018,
      ' 0-10-1986',
      9.039694,
      13.577086,
      18.776104,
      11,
      '11-14-1998',
      4,
      NULL,
      88,
      ' 9-24-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1);
commit;
end;
/


