set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9034332';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0234',
      '44121134',
      '13023341',
      NULL,
      '32412212',
      '31440214',
      '03244341',
      '32040042',
      '12004212',
      '42142320',
      '43000412',
      '24241400',
      '04212123',
      NULL,
      '22123103',
      '32112210',
      '23402104',
      '03044000',
      NULL,
      '14141403',
      '11022232',
      '44011440',
      '12244443',
      '42243444',
      '02444311',
      '31321333',
      '22134412',
      '02041110',
      '30232311',
      '24020334',
      NULL,
      '24001404',
      '13033204',
      '03343414',
      '40431414',
      '12202431',
      NULL,
      '31032221',
      '12043320',
      '30020230',
      '41423333',
      '31110342',
      NULL,
      '42121332',
      '11034400',
      '040',
      '13',
      NULL,
      NULL,
      '3131204',
      3.637173,
      30,
      NULL,
      NULL,
      '244443',
      3.531708,
      NULL,
      ' 7-26-1977',
      22.265975,
      NULL,
      3,
      18,
      0.133028,
      5.586409,
      76.680575,
      NULL,
      20,
      13.919895,
      14.834136,
      0,
      22.114010,
      20.080260,
      5,
      2.902620,
      12.501544,
      10,
      26.177644,
      NULL,
      15,
      NULL,
      60.808623,
      0.236022,
      NULL,
      44,
      124.959585,
      35.069374,
      NULL,
      103,
      70,
      NULL,
      NULL,
      29,
      31.189932,
      33.031772,
      34.888736,
      130.854932,
      ' 6-28-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      50.741651,
      52,
      9,
      23,
      13,
      0.205089,
      ' 1-14-1977',
      1,
      0,
      221,
      0.178388,
      0.214646,
      65.648383,
      NULL,
      1,
      12.083328,
      NULL,
      NULL,
      NULL,
      NULL,
      31.520080,
      72.978018,
      20.237085,
      1,
      53,
      59,
      32.188908,
      NULL,
      41,
      68,
      19.992859,
      47.064048,
      ' 2- 3-2002',
      37.085947,
      2.858117,
      7,
      92.023559,
      29,
      NULL,
      4,
      '10- 3-1996',
      22,
      12,
      ' 2-10-2003',
      3,
      12.847143,
      NULL,
      5.260159,
      6.830017,
      0,
      1.918188,
      4.483217,
      0,
      84.940951,
      0,
      NULL,
      0.511921,
      22.309264,
      1.571612,
      NULL,
      2,
      0.312476,
      ' 2- 9-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      145,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      31,
      NULL,
      7,
      ' 0- 4-2000',
      8,
      3.995405,
      '11-21-1998',
      NULL,
      NULL,
      NULL,
      1,
      0.930664,
      ' 4-28-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10.156608,
      ' 9-11-1984',
      57.381436,
      36.730677,
      38,
      ' 9- 6-1980',
      3.188544,
      42.992381,
      '11-25-1977',
      0,
      19.833527,
      20,
      NULL,
      ' 4-28-1986',
      15,
      1.530311,
      122,
      ' 0-25-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


