set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9034332';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '2',
      '2',
      '3',
      '2',
      NULL,
      '1',
      '1',
      '2',
      '2',
      '2',
      '2',
      NULL,
      NULL,
      '1',
      NULL,
      '4',
      '1',
      '0',
      NULL,
      '4',
      '1',
      '4',
      '4',
      '',
      NULL,
      '',
      '4',
      '3',
      '2',
      '0',
      '2',
      '',
      '',
      '0',
      '4',
      '3',
      '3',
      '4',
      NULL,
      NULL,
      NULL,
      '0',
      '2',
      '1',
      '404',
      NULL,
      54.855617,
      27.386842,
      '0042141',
      1.864528,
      137,
      0,
      NULL,
      '300343',
      0,
      '10- 5-1979',
      ' 4-18-1974',
      95,
      NULL,
      1,
      26,
      28.679238,
      2.339554,
      51.791758,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      6,
      13,
      NULL,
      10,
      3,
      20.439620,
      NULL,
      21,
      NULL,
      1,
      0.640076,
      10,
      0.784307,
      51.116464,
      76.975340,
      64.895664,
      31.838571,
      NULL,
      119.623291,
      '10-11-2002',
      33,
      NULL,
      NULL,
      33.937745,
      125.196764,
      142.056930,
      ' 4-22-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      33,
      44,
      25,
      1.816071,
      NULL,
      3.638074,
      ' 8-24-1999',
      0,
      0.164914,
      156.584639,
      0,
      1.237181,
      130,
      0,
      0,
      25.187530,
      NULL,
      NULL,
      NULL,
      '10-24-1989',
      52,
      62.263532,
      65.204904,
      56,
      46.460634,
      NULL,
      NULL,
      57.443917,
      9.112567,
      17,
      68.429731,
      43,
      ' 2-21-1981',
      4.562544,
      11,
      6.930244,
      22,
      75,
      NULL,
      2,
      '11-24-1982',
      24.986999,
      11.727917,
      ' 2-18-1986',
      4.741834,
      5,
      17,
      2,
      6.512335,
      3,
      NULL,
      0.110623,
      1,
      17.953150,
      2.508358,
      1.530370,
      4,
      17,
      0,
      0.741484,
      1.690708,
      1.080711,
      ' 1- 6-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      '10- 4-1991',
      NULL,
      NULL,
      NULL,
      10,
      ' 2-23-1998',
      16.936816,
      ' 9-25-1997',
      14.411235,
      15.176702,
      '11-11-1981',
      43.387106,
      95,
      '11-20-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      6.850456,
      '10-26-1978',
      28.422534,
      25.071796,
      1.654700,
      ' 0-18-1995',
      1,
      104.360629,
      NULL,
      NULL,
      19,
      12,
      84.691266,
      ' 3-20-2000',
      13.734645,
      0,
      2.152689,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


