set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9034332';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '4',
      '2',
      '1',
      '0',
      '2',
      NULL,
      NULL,
      '1',
      '3',
      '1',
      NULL,
      '4',
      '3',
      '1',
      '0',
      '4',
      '0',
      '3',
      '3',
      '2',
      '0',
      '4',
      NULL,
      '',
      '0',
      '',
      NULL,
      '3',
      '2',
      '2',
      '4',
      '',
      NULL,
      '0',
      '2',
      '3',
      NULL,
      NULL,
      '4',
      '4',
      '4',
      '2',
      '4',
      NULL,
      '202',
      '13012210',
      30.731810,
      29.362992,
      '3231013',
      3,
      NULL,
      1,
      1,
      '010314',
      4,
      ' 2-15-1979',
      ' 9-29-1996',
      3,
      54,
      NULL,
      25.659192,
      NULL,
      6.948134,
      NULL,
      9.983953,
      15.657329,
      17,
      NULL,
      17,
      13,
      26.668188,
      4.953275,
      9,
      33,
      15.313621,
      47,
      13.212038,
      6.812716,
      19,
      10.234933,
      2,
      0,
      NULL,
      49.871244,
      59,
      NULL,
      242,
      204,
      ' 0-16-1979',
      NULL,
      NULL,
      NULL,
      6,
      64,
      NULL,
      '10-27-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      53.583236,
      14,
      15.398782,
      10,
      NULL,
      NULL,
      ' 5- 3-1987',
      1.420836,
      NULL,
      137,
      NULL,
      3,
      147,
      NULL,
      0.753030,
      49,
      NULL,
      NULL,
      NULL,
      ' 7-25-1978',
      61,
      35.722125,
      37,
      65.179235,
      33,
      NULL,
      NULL,
      24.866868,
      92,
      74.652242,
      NULL,
      88.582836,
      ' 3-28-1994',
      NULL,
      30,
      NULL,
      53,
      66,
      7.828932,
      1,
      ' 1-27-1976',
      10.526248,
      13.541716,
      NULL,
      4.720065,
      6,
      NULL,
      NULL,
      7,
      8,
      0.948664,
      22,
      1.083583,
      125,
      0.197136,
      NULL,
      18.951899,
      18,
      1.398373,
      1.551164,
      1.256734,
      0,
      ' 9-29-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      184,
      NULL,
      '11-24-1990',
      NULL,
      NULL,
      NULL,
      40.734781,
      NULL,
      1.572954,
      NULL,
      4,
      15,
      NULL,
      90.840568,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      21,
      ' 5-26-1988',
      NULL,
      43,
      16.669775,
      NULL,
      5.247804,
      124,
      NULL,
      18,
      8.260495,
      NULL,
      27,
      NULL,
      22.240933,
      0,
      54,
      ' 8- 4-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


