set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8526502';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0211',
      NULL,
      '43242031',
      '41102414',
      '33310444',
      NULL,
      '33340323',
      '33134200',
      '14244043',
      '12022402',
      NULL,
      '33232413',
      NULL,
      '34121014',
      '31420424',
      '23442043',
      '32030122',
      '40440001',
      '03001323',
      NULL,
      '02321122',
      '31024141',
      '12424300',
      '22144131',
      '23433031',
      NULL,
      NULL,
      '24211011',
      '23244313',
      '30413424',
      '03014031',
      '10410412',
      '22121200',
      '21044041',
      '31423204',
      '04321144',
      '22414020',
      NULL,
      '33031303',
      '04411032',
      '14404101',
      '34311431',
      NULL,
      '04224042',
      '30242040',
      '321',
      '14',
      15.097439,
      NULL,
      NULL,
      0,
      0.367630,
      NULL,
      NULL,
      '442110',
      0.787603,
      ' 2- 9-1995',
      ' 3-19-1986',
      67.485281,
      NULL,
      2.404017,
      11,
      NULL,
      17.393549,
      17.437226,
      NULL,
      NULL,
      12,
      NULL,
      18,
      47,
      NULL,
      NULL,
      2,
      28.236161,
      12.529107,
      90,
      NULL,
      26,
      1.341690,
      71.590222,
      29.520256,
      0.537465,
      5.686944,
      175,
      113,
      NULL,
      156.773164,
      17,
      ' 5- 9-1996',
      38,
      35.130333,
      31,
      9,
      116,
      NULL,
      ' 8-29-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      8,
      19.715880,
      NULL,
      6,
      ' 7-12-1997',
      1,
      1.939297,
      88.813649,
      0,
      1.849312,
      89.648626,
      1,
      3,
      103,
      NULL,
      NULL,
      NULL,
      ' 2-25-1993',
      63,
      73,
      39.230520,
      73,
      99.126687,
      NULL,
      NULL,
      92,
      17.360617,
      47.225472,
      27,
      67.817099,
      NULL,
      9.253768,
      28.752659,
      2.564900,
      34,
      93.216047,
      156,
      NULL,
      ' 4-27-1994',
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      24,
      2,
      NULL,
      2,
      0.362151,
      0,
      0,
      6,
      0.854135,
      0.190398,
      2.367474,
      3.402226,
      NULL,
      NULL,
      0.659352,
      3.409429,
      ' 2-14-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      140.100531,
      0,
      ' 7-20-2002',
      NULL,
      NULL,
      NULL,
      24.359427,
      ' 3- 8-1980',
      31.011291,
      NULL,
      NULL,
      9,
      ' 0- 2-1983',
      NULL,
      44.616687,
      ' 1-28-1980',
      9.881202,
      19,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      21.503807,
      ' 6-18-1991',
      3.679858,
      51.661111,
      11.713766,
      ' 9-22-1991',
      0,
      27.092822,
      ' 5-12-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


