set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8526502';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0443',
      '43400132',
      NULL,
      '24121134',
      '02133000',
      '03011123',
      '01111320',
      '32240421',
      '01243114',
      NULL,
      NULL,
      '32312312',
      '14014240',
      '44033124',
      '00130301',
      '31144324',
      '22134323',
      '02414232',
      '14122323',
      '10124304',
      '01442442',
      '41234242',
      '23401222',
      '20220212',
      '40241203',
      '21441421',
      NULL,
      '10314432',
      '41411040',
      NULL,
      '24100232',
      '01300104',
      NULL,
      NULL,
      '24440344',
      '30400142',
      '33104442',
      '34440031',
      '20242231',
      '23014013',
      NULL,
      '30432131',
      '43344424',
      '44343424',
      '34100342',
      '310',
      '42',
      13,
      4,
      '1014230',
      2.284964,
      NULL,
      1,
      NULL,
      '101243',
      0.551128,
      ' 2-12-2003',
      NULL,
      NULL,
      29,
      6,
      17,
      NULL,
      1,
      NULL,
      13,
      12,
      21.024780,
      5,
      15.513344,
      9,
      22.566271,
      17,
      2,
      2,
      NULL,
      0,
      8.122669,
      36,
      1,
      15.401622,
      1,
      NULL,
      115.035761,
      53,
      101.736456,
      NULL,
      NULL,
      249,
      ' 1-17-1982',
      64.220561,
      60.807295,
      24,
      19,
      24,
      NULL,
      ' 4-29-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      107,
      4,
      NULL,
      4.487006,
      6,
      1.139741,
      NULL,
      1.084921,
      1.033386,
      NULL,
      0,
      NULL,
      34,
      1.949246,
      1.887295,
      104.436607,
      NULL,
      NULL,
      NULL,
      ' 8- 3-1975',
      18,
      92,
      103,
      12.189095,
      93,
      NULL,
      83,
      4,
      28.942429,
      46,
      36,
      11.840438,
      ' 7-11-1987',
      19.449971,
      41.130541,
      NULL,
      100,
      109.286877,
      156.490087,
      15.367467,
      ' 9-20-1995',
      13.297851,
      1.005850,
      ' 8- 4-2003',
      NULL,
      6.999135,
      8.472973,
      27,
      NULL,
      7,
      1,
      11.116364,
      1.599988,
      NULL,
      0.277962,
      1.701191,
      21,
      NULL,
      0.671843,
      0,
      0.713912,
      1.942574,
      ' 4-29-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      272,
      2.355213,
      ' 1-25-1992',
      NULL,
      NULL,
      NULL,
      20,
      '10- 1-1981',
      NULL,
      ' 6- 4-1984',
      11.424203,
      18.873678,
      ' 0- 0-1999',
      26.066617,
      67.216860,
      ' 2-14-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      17,
      ' 9- 3-1984',
      NULL,
      33,
      14,
      ' 1-12-1986',
      1,
      29,
      ' 7-28-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


