set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9753217';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '3',
      '1',
      '2',
      NULL,
      '4',
      '4',
      '0',
      '1',
      '3',
      '0',
      NULL,
      '3',
      '1',
      NULL,
      '2',
      '2',
      NULL,
      '1',
      '4',
      '1',
      '4',
      NULL,
      '1',
      '',
      NULL,
      '',
      '2',
      '3',
      '1',
      NULL,
      NULL,
      '',
      '',
      '2',
      '1',
      '0',
      '1',
      '4',
      '0',
      '4',
      NULL,
      '4',
      '4',
      '0',
      '423',
      '43314224',
      50.832316,
      36.734237,
      NULL,
      2,
      1.480460,
      2,
      NULL,
      NULL,
      2,
      NULL,
      ' 1- 2-1979',
      15,
      44.350291,
      NULL,
      NULL,
      14,
      9,
      42,
      15,
      NULL,
      NULL,
      35.913794,
      6,
      40,
      26.180125,
      9,
      9.846321,
      21.847580,
      14.426278,
      4,
      0,
      16,
      11.675081,
      34,
      8.773293,
      1,
      85,
      52.078326,
      1,
      50.152702,
      109.188637,
      160.885157,
      NULL,
      26,
      70,
      13.002506,
      3,
      158,
      98.268193,
      ' 2-11-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      53,
      28,
      4,
      6.658276,
      8,
      9,
      '11-10-1979',
      NULL,
      1.646042,
      4,
      0,
      5.277397,
      NULL,
      1.392700,
      1.416114,
      30,
      NULL,
      NULL,
      NULL,
      '10- 2-1976',
      9,
      NULL,
      NULL,
      96.159319,
      90,
      35,
      48.326728,
      36,
      63.254592,
      19.022066,
      3,
      73.455482,
      '11-23-1994',
      4.018905,
      NULL,
      NULL,
      36.789390,
      9,
      NULL,
      7,
      ' 5-23-1980',
      11,
      27.303731,
      ' 6-20-1996',
      10.485588,
      13.773700,
      12.133162,
      16,
      15,
      6,
      0.654166,
      21,
      0.301623,
      96.118372,
      0,
      1,
      NULL,
      14.316479,
      1,
      1.112727,
      NULL,
      1.871136,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      60.851049,
      1,
      ' 3-23-1975',
      NULL,
      NULL,
      NULL,
      20,
      ' 0-24-1977',
      5,
      ' 1-21-1996',
      NULL,
      10.016192,
      ' 5-17-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5.965801,
      ' 8-16-1984',
      12,
      52,
      26.918342,
      ' 7- 8-1986',
      NULL,
      35.901507,
      ' 1-26-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


