set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7425231';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '33003114',
      '01424212',
      NULL,
      NULL,
      '43224441',
      '33403133',
      '40202404',
      '22121403',
      NULL,
      NULL,
      '14100222',
      NULL,
      NULL,
      '22004412',
      '44401332',
      '14133324',
      '14443033',
      '02413040',
      '23233340',
      '03404123',
      '04400320',
      NULL,
      '43342342',
      '34033224',
      NULL,
      '12344123',
      '10442013',
      '33220414',
      '12002002',
      '14022444',
      NULL,
      '10104221',
      '21214411',
      '42112023',
      '04030030',
      NULL,
      NULL,
      '03302013',
      NULL,
      '40443042',
      '12020414',
      '30214341',
      '00011221',
      '14414010',
      '130',
      '23',
      6.983246,
      18.372598,
      '2324312',
      0,
      0,
      2,
      NULL,
      '234020',
      2.605599,
      ' 5-24-1975',
      ' 0-21-1999',
      7.786257,
      7,
      27,
      31.771366,
      23.684927,
      NULL,
      74,
      21.376631,
      26,
      16.239975,
      41,
      13.449169,
      24.605330,
      5,
      25.063801,
      14.455419,
      17,
      9,
      NULL,
      1,
      55.030513,
      13.225955,
      70,
      2,
      0.129169,
      NULL,
      170,
      15.642678,
      140,
      185,
      178.066126,
      ' 1-19-1990',
      34.999827,
      7,
      14,
      24.615113,
      5,
      53,
      ' 7- 5-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      51,
      54.243294,
      38,
      28.571306,
      38.051726,
      NULL,
      ' 0-14-1981',
      1.814447,
      1.210156,
      86,
      1.361937,
      0.309160,
      102,
      1.389184,
      5.021958,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-27-1981',
      65,
      71.361799,
      42.457017,
      34,
      45,
      2,
      69.879904,
      100,
      0,
      75.622970,
      16.495023,
      50.220759,
      ' 9- 6-1993',
      NULL,
      2.490385,
      10.088399,
      23,
      1,
      8,
      NULL,
      ' 1- 7-1991',
      18,
      14.013920,
      ' 1- 1-1981',
      8,
      4.934039,
      6.382943,
      2,
      NULL,
      2,
      1,
      0,
      0.328421,
      34,
      NULL,
      6.621100,
      11.282273,
      17,
      NULL,
      3,
      2.848270,
      3.002098,
      ' 7-28-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      62,
      NULL,
      ' 1-26-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      38,
      ' 0- 7-1976',
      7.468853,
      5.234133,
      ' 2-15-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      ' 2- 5-2000',
      38.795800,
      3,
      4,
      ' 3-19-1985',
      1,
      79.460906,
      ' 1- 7-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      71,
      1.447926,
      73,
      ' 5-11-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


