set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9425957';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0344',
      '00423232',
      '40234234',
      NULL,
      '41040121',
      NULL,
      '41023343',
      '00213003',
      '11343230',
      NULL,
      NULL,
      '20121101',
      '44100120',
      '10313322',
      '31213312',
      '03114423',
      '14014442',
      '40440334',
      '41122433',
      '41120334',
      '04011232',
      '12410034',
      '04421124',
      '02024402',
      '00000001',
      '10121412',
      '04132404',
      '20410023',
      '12303443',
      '11441204',
      '03042221',
      '44031020',
      '42233311',
      '11124000',
      NULL,
      '11434240',
      '01113413',
      '22103112',
      '32321322',
      '02002121',
      '40034402',
      '31302210',
      NULL,
      '03310030',
      NULL,
      '011',
      '10',
      NULL,
      NULL,
      '3042032',
      3,
      1.388982,
      1,
      NULL,
      '440111',
      0.279084,
      ' 6-26-1986',
      NULL,
      27,
      NULL,
      17.357292,
      3.690433,
      22,
      3,
      112.096404,
      23.712996,
      19,
      17,
      0.383868,
      6,
      3.072771,
      22.759957,
      10,
      10,
      0,
      0.525063,
      27.504476,
      4,
      24.496651,
      8,
      20,
      4,
      0,
      39.571773,
      126,
      6.957432,
      122,
      NULL,
      48.657944,
      ' 5-28-1974',
      4,
      19,
      1.581957,
      6,
      118.320001,
      173,
      ' 8- 0-2003',
      4,
      1,
      NULL,
      NULL,
      NULL,
      6,
      0,
      NULL,
      NULL,
      1.479597,
      10,
      2.032326,
      NULL,
      0,
      0,
      0.909941,
      2.156118,
      1.297041,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-23-1997',
      34.195006,
      12,
      7,
      NULL,
      39,
      NULL,
      ' 3-21-1979',
      0.187433,
      1.495043,
      85.326590,
      0,
      9.576242,
      96.554708,
      1,
      0.739856,
      19,
      NULL,
      NULL,
      NULL,
      '10-29-1975',
      NULL,
      86.520368,
      55.671596,
      122.722618,
      51,
      50,
      37,
      13,
      47,
      50,
      NULL,
      41.994591,
      NULL,
      3,
      4.831250,
      NULL,
      18.210343,
      NULL,
      3,
      0,
      ' 6-27-1994',
      NULL,
      16.846772,
      ' 4- 0-2002',
      3,
      1,
      1,
      6,
      18,
      2.384282,
      0,
      23,
      0.638952,
      NULL,
      2,
      2,
      22.428910,
      12.725047,
      1.474888,
      NULL,
      0.199870,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      83.367658,
      2.388143,
      '11-15-2001',
      NULL,
      NULL,
      NULL,
      47.953916,
      ' 8- 1-2000',
      28.880121,
      NULL,
      8,
      2,
      ' 7-15-1975',
      NULL,
      NULL,
      NULL,
      0.281685,
      0,
      ' 4-17-1998',
      NULL,
      NULL,
      NULL,
      2,
      1,
      9.260039,
      NULL,
      NULL,
      3.858212,
      13,
      NULL,
      2.410966,
      192,
      NULL,
      NULL,
      36.709366,
      NULL,
      NULL,
      '11-17-1995',
      62,
      0.687583,
      111,
      ' 4-27-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


