set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9204259';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0234',
      NULL,
      '23003240',
      '04313331',
      NULL,
      '33203031',
      '12110131',
      '10233431',
      '02321004',
      NULL,
      '42244242',
      '11142134',
      NULL,
      '04123224',
      '41101422',
      '22102023',
      '43220422',
      '11330220',
      '32003212',
      '12331201',
      '31141231',
      '31233141',
      '23110344',
      '02232100',
      '22212030',
      NULL,
      '33141343',
      '33324434',
      NULL,
      '24003024',
      NULL,
      '42330422',
      '41140022',
      '42313012',
      '33442001',
      NULL,
      '20241034',
      '32343333',
      '22320333',
      NULL,
      NULL,
      '00341412',
      '32424002',
      '20043122',
      NULL,
      '213',
      '30',
      NULL,
      NULL,
      '0021021',
      1.030411,
      1,
      1,
      NULL,
      NULL,
      3.649182,
      ' 7-26-2003',
      NULL,
      3,
      NULL,
      12,
      9,
      26,
      11.106652,
      18,
      10,
      7,
      10.629649,
      24,
      NULL,
      NULL,
      15.957125,
      6,
      6,
      20.130959,
      12.239255,
      74,
      9,
      41,
      13,
      52.659015,
      4.160460,
      0,
      33,
      120,
      75,
      12.491968,
      105,
      52,
      ' 0-12-1982',
      11.947651,
      31.225870,
      11.463312,
      19.337028,
      176,
      76.103889,
      NULL,
      2,
      NULL,
      3,
      0.815366,
      3.886690,
      0,
      NULL,
      0.516705,
      0.774548,
      0.596110,
      2,
      1,
      0.317488,
      1.414946,
      1,
      0.396382,
      1,
      1.596409,
      0.584901,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-10-2002',
      85.966055,
      7,
      NULL,
      1,
      4.703127,
      6.419182,
      ' 7-24-1982',
      1.231772,
      NULL,
      167.025021,
      NULL,
      0,
      NULL,
      1.553890,
      6,
      100.301070,
      0,
      0,
      42,
      ' 5-17-1996',
      45.925818,
      83,
      24,
      30.366760,
      NULL,
      23.906113,
      NULL,
      91.027181,
      82,
      NULL,
      10,
      70,
      ' 6-14-1981',
      NULL,
      NULL,
      NULL,
      25.249994,
      72,
      100.218728,
      10.280826,
      ' 9-29-1998',
      0,
      1,
      ' 3- 2-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10.249232,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-18-1980',
      7.944189,
      1.198407,
      2,
      NULL,
      NULL,
      7.446925,
      ' 5-20-1992',
      NULL,
      NULL,
      NULL,
      54,
      NULL,
      NULL,
      NULL,
      14,
      15,
      ' 3- 6-1989',
      115.193775,
      NULL,
      ' 2-25-1994',
      NULL,
      1,
      '11-24-1986',
      7,
      9.563328,
      ' 2- 1-1981',
      1,
      NULL,
      20.141969,
      NULL,
      NULL,
      NULL,
      9,
      '10- 9-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2);
commit;
end;
/


