set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9800889';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '0',
      '3',
      '2',
      '0',
      '2',
      '2',
      NULL,
      '2',
      '3',
      '4',
      '2',
      '4',
      NULL,
      '1',
      '1',
      '2',
      '0',
      '1',
      '3',
      '2',
      NULL,
      '2',
      '1',
      NULL,
      '4',
      '',
      '3',
      '3',
      '3',
      '1',
      '2',
      NULL,
      '',
      '3',
      NULL,
      '4',
      '1',
      '0',
      '2',
      '2',
      '2',
      '1',
      '2',
      '1',
      '003',
      '34310314',
      5.966909,
      3.251399,
      NULL,
      0,
      1.304060,
      NULL,
      NULL,
      '241124',
      NULL,
      ' 7- 0-1977',
      ' 9- 3-1991',
      NULL,
      NULL,
      14,
      20.454943,
      10.439920,
      11,
      76.750053,
      1,
      NULL,
      3.408871,
      13.435604,
      0,
      17.524343,
      18,
      17,
      17,
      10.362649,
      9,
      53,
      20,
      15.142324,
      NULL,
      143,
      28.668287,
      NULL,
      NULL,
      NULL,
      54.505359,
      NULL,
      49,
      193,
      ' 6-15-1996',
      42.209505,
      21.617831,
      5,
      0.498954,
      64.620016,
      NULL,
      ' 7-29-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      20,
      NULL,
      15,
      7,
      5,
      8.878060,
      '11-29-1981',
      1,
      0.775739,
      61.568908,
      0.703445,
      1.183383,
      84.303295,
      1,
      0.590965,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-19-1982',
      49.689969,
      NULL,
      67,
      14,
      NULL,
      45,
      1.904393,
      12.136886,
      39.590959,
      54.485311,
      37.820275,
      26,
      ' 1- 6-2000',
      29,
      39,
      3,
      9.780485,
      85,
      141.673780,
      NULL,
      ' 1-13-1976',
      25,
      8.183883,
      ' 5-21-2002',
      NULL,
      13,
      14,
      3,
      1.064346,
      2,
      0,
      12,
      0,
      91.225949,
      NULL,
      0.732069,
      8.711918,
      NULL,
      1.808926,
      1.246614,
      0,
      0,
      ' 6-17-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      117,
      NULL,
      ' 8- 9-1974',
      NULL,
      NULL,
      NULL,
      28,
      ' 3-20-1988',
      NULL,
      ' 1- 5-1987',
      9.262792,
      4.409934,
      ' 5-11-1981',
      68.399864,
      85,
      ' 0-24-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      18.388145,
      ' 9-13-1980',
      22.577173,
      52.035610,
      20,
      ' 9- 4-1990',
      2,
      70.850058,
      ' 0- 7-1991',
      1,
      NULL,
      3.051761,
      39.765887,
      ' 1-24-1982',
      68.128572,
      1.272695,
      30,
      ' 6- 3-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


