set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9023528';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '3',
      NULL,
      '2',
      NULL,
      '4',
      '1',
      '1',
      NULL,
      '2',
      '4',
      '0',
      '3',
      '3',
      '3',
      NULL,
      '0',
      NULL,
      NULL,
      '0',
      NULL,
      '2',
      '1',
      '0',
      NULL,
      '4',
      '',
      '4',
      '2',
      '2',
      '3',
      NULL,
      NULL,
      '',
      '0',
      '2',
      '1',
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      '2',
      '2',
      '0',
      '233',
      NULL,
      78.731618,
      74,
      '0220043',
      0.656572,
      NULL,
      0,
      1,
      '001223',
      4.031005,
      ' 8-10-1979',
      NULL,
      31,
      213.266311,
      49,
      24.125820,
      NULL,
      5.030917,
      NULL,
      18,
      29,
      23,
      9,
      0,
      14,
      6.640568,
      29.849868,
      0,
      0,
      3.283476,
      37.448570,
      6.353425,
      NULL,
      11.886894,
      NULL,
      12.029215,
      0,
      122,
      NULL,
      NULL,
      186.253743,
      209,
      NULL,
      ' 7-26-1989',
      53,
      37.521701,
      26,
      NULL,
      NULL,
      100,
      ' 8-29-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      61.240793,
      16,
      4,
      15.754356,
      7,
      0,
      ' 0-19-1993',
      0,
      1,
      177,
      0.302754,
      0,
      101.077221,
      0,
      1.945493,
      30,
      NULL,
      NULL,
      NULL,
      NULL,
      26.050000,
      42.461856,
      14.934075,
      NULL,
      6.817781,
      32.925284,
      34.293135,
      27.464984,
      65,
      77.935571,
      0.333641,
      73,
      ' 0-27-1995',
      11,
      17.709881,
      2,
      34.043290,
      16,
      77,
      NULL,
      NULL,
      9,
      13.375656,
      ' 4-19-2002',
      11.391704,
      12.998430,
      13.473861,
      4.500249,
      0.589580,
      NULL,
      1.757748,
      8.304982,
      1,
      50.408134,
      1,
      NULL,
      8,
      7,
      0,
      1.531176,
      1,
      0,
      ' 4-23-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      35.650148,
      5.882368,
      ' 9- 2-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-22-1974',
      46,
      ' 3-18-1999',
      13.144269,
      3,
      ' 5- 0-1981',
      99.671587,
      50,
      ' 5-16-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.702501,
      '11-13-1997',
      28,
      NULL,
      2,
      ' 3-24-1993',
      0.569112,
      11.141256,
      ' 1- 0-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


