set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9015229';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1300',
      NULL,
      '40314431',
      '32103313',
      '34004134',
      '42204142',
      NULL,
      '31341043',
      '40244201',
      '12300343',
      '44111231',
      '14041431',
      NULL,
      '44212013',
      '33331432',
      '12414341',
      NULL,
      '12140221',
      '31034430',
      '23441022',
      '30023220',
      NULL,
      '33043103',
      '41230434',
      '23040240',
      '00020144',
      '20114003',
      '32130431',
      '01320342',
      '44134322',
      NULL,
      NULL,
      '44432430',
      NULL,
      '02412343',
      '00322422',
      '24413304',
      '40101220',
      '02432012',
      '30000131',
      '44144132',
      '01401403',
      '22134420',
      '22132342',
      '13433001',
      '',
      '',
      NULL,
      NULL,
      '2211300',
      3,
      NULL,
      0,
      NULL,
      '313223',
      NULL,
      ' 1-25-1981',
      ' 9-15-1981',
      NULL,
      NULL,
      24,
      2,
      NULL,
      NULL,
      31.941850,
      NULL,
      16.546552,
      3.109686,
      NULL,
      8,
      24.663289,
      NULL,
      20,
      4.381705,
      NULL,
      23,
      16.058410,
      1.865277,
      NULL,
      28.931923,
      34.332842,
      NULL,
      NULL,
      NULL,
      119,
      98.978989,
      229,
      NULL,
      132,
      '10-10-1981',
      NULL,
      NULL,
      16.136528,
      35.710711,
      230.122148,
      NULL,
      ' 5-21-1984',
      0.890603,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-18-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11- 4-2002',
      13.316572,
      25.984395,
      42,
      119,
      73.638397,
      NULL,
      120.912027,
      111.072776,
      28.198124,
      85,
      105,
      75,
      ' 0-24-1984',
      24.942658,
      NULL,
      12,
      81,
      14.694679,
      41.367785,
      2.667893,
      ' 8-17-1978',
      16,
      NULL,
      ' 7-16-1988',
      5,
      NULL,
      2,
      10.586346,
      9.044197,
      17,
      NULL,
      10,
      NULL,
      81,
      3.407664,
      NULL,
      7.149621,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-14-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      64.268731,
      '10-26-2000',
      1.439877,
      42,
      NULL,
      12.967878,
      17,
      11,
      12,
      NULL,
      32,
      1,
      NULL,
      ' 4- 3-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      1.056934,
      1.112575,
      NULL,
      NULL,
      121,
      16.911702,
      NULL,
      5.468982,
      7,
      NULL,
      NULL,
      NULL,
      1.888798,
      47.432144,
      1.381508,
      4.680260,
      79,
      NULL,
      4,
      32.139966,
      4,
      0,
      120.441385,
      NULL,
      NULL,
      NULL,
      1.346833,
      NULL,
      NULL,
      1,
      1.626661,
      0.086336,
      NULL,
      1.685520,
      NULL,
      NULL,
      NULL,
      24,
      NULL,
      NULL,
      1,
      1,
      3,
      1.559876,
      1.537634,
      NULL,
      8,
      NULL,
      NULL,
      1.390503,
      NULL,
      1,
      1.603038,
      NULL,
      9.932665,
      8.630475,
      NULL,
      NULL,
      NULL,
      13.114237,
      NULL,
      16.125519,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.354558,
      0.930471,
      NULL,
      ' 7- 8-1986',
      NULL,
      ' 7-24-1998',
      NULL,
      '10-24-1981',
      ' 2- 6-1996',
      '10- 6-1982',
      NULL);
commit;
end;
/


