set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9030654';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2332',
      '40422343',
      '24110332',
      '22100404',
      NULL,
      '20301424',
      '23143243',
      '32141231',
      NULL,
      '41444243',
      '11300213',
      '22142102',
      '12210320',
      '31242443',
      '22241230',
      '33304301',
      '00131302',
      '13233200',
      '21102430',
      '43310002',
      '12344302',
      '10232401',
      '12240342',
      '23020321',
      '42101134',
      '30212020',
      '20240040',
      '14230020',
      '13142313',
      '02230313',
      '43144443',
      '42040411',
      NULL,
      NULL,
      '12103441',
      NULL,
      '11001421',
      '14213422',
      '22043330',
      '40203420',
      '14411122',
      '30402231',
      '24243023',
      '23101010',
      '31010410',
      '',
      '',
      NULL,
      NULL,
      NULL,
      3.780623,
      NULL,
      2,
      NULL,
      '201003',
      0,
      '11-21-1989',
      ' 8-10-1998',
      3.481540,
      NULL,
      20,
      10.179591,
      NULL,
      NULL,
      34,
      8.825816,
      0.762324,
      9,
      30.693599,
      1,
      15,
      25,
      12,
      NULL,
      NULL,
      11.734250,
      3,
      6.558613,
      42,
      0.569186,
      63.665328,
      NULL,
      NULL,
      34.139611,
      13.813402,
      3,
      6,
      100.218931,
      45.084554,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.054797,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.553561,
      1,
      2,
      0,
      1.675890,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-10-1985',
      49.838121,
      36,
      31,
      NULL,
      0.349442,
      37,
      NULL,
      15.692539,
      NULL,
      34.308177,
      64,
      56,
      ' 2-12-2002',
      25.995104,
      0,
      12,
      57,
      NULL,
      75.992655,
      6,
      NULL,
      13,
      11,
      ' 2-10-2003',
      3,
      9,
      NULL,
      3,
      NULL,
      1.275938,
      NULL,
      13,
      NULL,
      8,
      0,
      NULL,
      1.381680,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8- 3-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      30,
      24,
      7,
      ' 1- 6-1976',
      NULL,
      NULL,
      NULL,
      2.336209,
      10,
      NULL,
      28,
      ' 0-10-1984',
      5,
      0,
      97.049112,
      ' 1-16-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      193,
      0.274696,
      NULL,
      115,
      35.113058,
      88.699466,
      23,
      73.238457,
      19,
      0,
      52.474036,
      1,
      NULL,
      54.856256,
      NULL,
      NULL,
      NULL,
      1,
      0.896731,
      NULL,
      NULL,
      0.629577,
      NULL,
      NULL,
      12.706877,
      69.661078,
      1.007442,
      68,
      1,
      NULL,
      1,
      0.795625,
      0,
      1.447083,
      29,
      117,
      50.666340,
      1.016236,
      23.981781,
      57.124089,
      NULL,
      NULL,
      22.504989,
      NULL,
      0,
      1.189156,
      7.439320,
      1,
      118,
      1,
      66,
      NULL,
      2,
      33.481067,
      1.422138,
      15.165857,
      33.923031,
      9,
      105.515096,
      NULL,
      NULL,
      NULL,
      4.019327,
      1.937290,
      4.656535,
      NULL,
      0,
      1,
      NULL,
      94.668196,
      NULL,
      NULL,
      NULL,
      ' 7-20-2000',
      NULL,
      NULL,
      ' 4- 4-1983',
      NULL);
commit;
end;
/


