set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9336131';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '04131001',
      NULL,
      NULL,
      '31141412',
      NULL,
      '11340002',
      NULL,
      '43233131',
      '10234140',
      '33410010',
      NULL,
      '23313131',
      '04441000',
      '04430423',
      '34401014',
      '01300023',
      '13143111',
      '02223101',
      '00213142',
      '30141204',
      '44414422',
      '00110030',
      '04022020',
      '43431331',
      '21001122',
      '03240021',
      '20143100',
      '44123032',
      '10244320',
      NULL,
      '03001222',
      '20423444',
      '33001132',
      '34432332',
      '34121042',
      '21332201',
      '42232131',
      '32203344',
      '34232042',
      '21324424',
      '04041144',
      '42301043',
      '40214124',
      '22010124',
      NULL,
      '11',
      NULL,
      NULL,
      '2320300',
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      ' 1- 2-1998',
      ' 3-12-1986',
      96,
      NULL,
      15,
      18,
      NULL,
      5,
      9.965016,
      6.614831,
      NULL,
      NULL,
      NULL,
      9.525883,
      2.910049,
      4.291949,
      NULL,
      1,
      1.629670,
      6.129905,
      16.025950,
      8.819563,
      61.573538,
      12,
      NULL,
      3.793669,
      1.708466,
      28.208426,
      66,
      NULL,
      132.223983,
      81,
      131,
      ' 3- 0-1983',
      28,
      3,
      14.922004,
      8,
      116.925349,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      72,
      85.864571,
      2,
      63,
      1.233582,
      '11- 7-1977',
      NULL,
      NULL,
      82.002981,
      1,
      0.376869,
      25,
      NULL,
      0,
      26,
      NULL,
      NULL,
      NULL,
      ' 8-20-1990',
      30.867525,
      4.631271,
      22.069185,
      2.504419,
      21.442692,
      0.474393,
      7,
      2.497446,
      43.069109,
      NULL,
      3,
      NULL,
      ' 5-15-1987',
      NULL,
      2,
      6.461962,
      40,
      NULL,
      21,
      6.959299,
      NULL,
      8.229643,
      2.640117,
      ' 3-15-1985',
      5.467007,
      0.816741,
      11,
      14,
      16.952595,
      7.981140,
      1,
      17,
      NULL,
      13.999615,
      7.047338,
      0,
      6.695496,
      29,
      1.403903,
      17,
      1,
      5,
      ' 2-10-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      22,
      '10- 7-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      45.069387,
      ' 1-13-1975',
      2.056790,
      4,
      ' 0- 6-2001',
      13,
      81,
      ' 9- 1-1999',
      1,
      5,
      ' 4-10-2000',
      NULL,
      NULL,
      NULL,
      0,
      1,
      10,
      NULL,
      36,
      NULL,
      23,
      ' 4-28-1987',
      0.652169,
      174,
      '11- 0-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


