set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9104323';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '30032022',
      '32200412',
      NULL,
      '00441332',
      '03341043',
      NULL,
      NULL,
      NULL,
      '33313131',
      '02322202',
      '43013424',
      '12224100',
      '13402213',
      '20331324',
      NULL,
      NULL,
      '12421232',
      '24034022',
      '22201121',
      NULL,
      '41130130',
      '32330210',
      '14104244',
      '21202004',
      '43010041',
      NULL,
      NULL,
      NULL,
      '43411022',
      '11443330',
      NULL,
      '12443012',
      '40234214',
      '20034002',
      '20330131',
      '00411004',
      '34343202',
      '01114232',
      '43213140',
      '10100020',
      '32422400',
      '30331213',
      '43011120',
      '22031413',
      NULL,
      '12',
      31.841592,
      NULL,
      '1233111',
      2.852497,
      0.511644,
      0,
      NULL,
      '103414',
      0.818632,
      NULL,
      ' 5- 7-1997',
      123,
      111,
      14.761951,
      12.306633,
      40.272693,
      17,
      70,
      18.047488,
      28,
      16,
      27.478147,
      24.563755,
      NULL,
      NULL,
      8.454125,
      12,
      10.395924,
      9.288545,
      19,
      NULL,
      33,
      3.169547,
      43.997528,
      11.409022,
      1,
      69.401984,
      91,
      78,
      27,
      229,
      200.564261,
      '10-22-1975',
      NULL,
      54.003200,
      4.150328,
      41,
      50.224596,
      NULL,
      ' 9- 5-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      19.538648,
      1,
      13,
      1,
      8,
      0,
      NULL,
      0.617158,
      1,
      85.760674,
      NULL,
      0,
      111,
      1.549499,
      1,
      0,
      NULL,
      NULL,
      NULL,
      ' 9- 0-1993',
      62.350538,
      67.972769,
      NULL,
      19.521919,
      9.834388,
      NULL,
      29,
      11.425949,
      82.801653,
      NULL,
      89.173322,
      NULL,
      NULL,
      NULL,
      16.126973,
      4,
      76,
      72.513669,
      61,
      NULL,
      ' 6-26-1981',
      20,
      10.495175,
      ' 4-14-1994',
      13.903077,
      17,
      11,
      12,
      4,
      10,
      0.088314,
      NULL,
      0.294164,
      63.388036,
      2,
      2.891795,
      7,
      9,
      9,
      NULL,
      2,
      3,
      ' 2-21-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      56,
      3,
      ' 0-12-1990',
      NULL,
      NULL,
      NULL,
      25,
      NULL,
      31.898659,
      NULL,
      3,
      1.721151,
      ' 2-20-1998',
      76,
      61,
      ' 0-10-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1,
      ' 9-21-1990',
      45.907810,
      13.109895,
      47,
      NULL,
      NULL,
      11,
      ' 6-20-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


