set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6453013';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2212',
      '31411324',
      '11024134',
      NULL,
      '42120201',
      '11121303',
      '34032020',
      '32310203',
      '32020004',
      NULL,
      '41340233',
      '03423304',
      '21110424',
      '21204114',
      '01224322',
      '42230244',
      '03101212',
      '14443314',
      '30033133',
      NULL,
      '40030314',
      '21001034',
      '31010403',
      '31121124',
      '04031413',
      '41204344',
      '40343302',
      '24302003',
      '14143041',
      '42232440',
      '34333220',
      '42004312',
      '11131142',
      '34120400',
      '34000331',
      '41423204',
      '04403011',
      '04400201',
      '10202443',
      '03101203',
      '42230304',
      '00340412',
      '44101024',
      '13103103',
      '14412324',
      '302',
      '20',
      NULL,
      NULL,
      '1313204',
      3.135266,
      1.279397,
      2,
      NULL,
      '121440',
      4,
      NULL,
      ' 3-20-1976',
      44.576184,
      NULL,
      19,
      3,
      NULL,
      2.758563,
      32.528097,
      5,
      11,
      17.673678,
      NULL,
      16,
      NULL,
      29,
      10,
      3,
      3,
      9,
      NULL,
      25,
      53.030915,
      NULL,
      NULL,
      NULL,
      0.406135,
      104,
      41,
      NULL,
      73,
      NULL,
      201,
      '10-14-1993',
      10,
      18,
      1,
      NULL,
      NULL,
      204,
      ' 1-16-1999',
      1.384154,
      12,
      5,
      5.600603,
      5,
      3,
      6,
      1.539357,
      NULL,
      1.652938,
      NULL,
      0.145093,
      NULL,
      8,
      NULL,
      0.136354,
      2.608562,
      1,
      0.520806,
      3.137731,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-24-1985',
      NULL,
      NULL,
      NULL,
      8,
      5,
      4.226777,
      '11-17-1997',
      1.304293,
      NULL,
      181,
      0.313111,
      NULL,
      9,
      0.785383,
      NULL,
      5.965073,
      1,
      1.538807,
      77,
      ' 4-29-1975',
      11,
      85.441580,
      26.817201,
      NULL,
      11.603846,
      58,
      9,
      93,
      37,
      29,
      33.492839,
      85,
      NULL,
      16,
      17.730813,
      10,
      32.411729,
      73.980305,
      18.062674,
      7,
      ' 7- 2-1990',
      6,
      1.208436,
      '11-28-1993',
      0.731422,
      6.082165,
      2,
      8,
      14.210833,
      NULL,
      0.877378,
      5,
      0,
      41.558907,
      0.518600,
      NULL,
      3.592890,
      NULL,
      1.370377,
      2,
      5,
      NULL,
      ' 6-29-1997',
      0.576375,
      4,
      2,
      ' 5- 1-1992',
      31.465355,
      18,
      ' 6- 8-1997',
      16,
      21,
      ' 9-29-2000',
      27,
      NULL,
      21.571024,
      ' 4- 0-1977',
      3,
      3,
      '11-15-1996',
      NULL,
      3,
      '10-21-1994',
      1.843012,
      0.588876,
      '10- 5-1993',
      NULL,
      2.171371,
      '11-21-2001',
      1,
      2,
      19,
      NULL,
      19,
      7.773649,
      4.994861,
      ' 1-11-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.703260);
commit;
end;
/


