set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8935013';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '10030003',
      NULL,
      '22334243',
      '10242410',
      NULL,
      '40433333',
      '12132243',
      '33022321',
      '44102032',
      '43032031',
      '42110403',
      '11004003',
      '02330324',
      '40220441',
      NULL,
      '11200130',
      '30330310',
      '41304333',
      NULL,
      NULL,
      NULL,
      '33024234',
      '44004133',
      '23004440',
      NULL,
      '03333110',
      NULL,
      '23332241',
      NULL,
      '12332212',
      NULL,
      '12113021',
      NULL,
      NULL,
      '43133031',
      '33224034',
      '01444240',
      NULL,
      '12332220',
      '00234201',
      '14140022',
      '21310130',
      '10234133',
      '02432401',
      '',
      '',
      NULL,
      NULL,
      '2142132',
      2.297339,
      0,
      NULL,
      NULL,
      '223100',
      0,
      ' 2-20-1996',
      NULL,
      76.057817,
      NULL,
      21.756963,
      5.504492,
      21,
      2,
      NULL,
      2,
      3.945724,
      3,
      7,
      11.649969,
      3.525044,
      NULL,
      1.877498,
      0.915724,
      0,
      9,
      7.883592,
      2,
      11.782280,
      10,
      10.652779,
      5,
      NULL,
      35,
      NULL,
      NULL,
      80.425775,
      66.999278,
      88.785660,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0.493288,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.439167,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-27-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2- 0-1999',
      68.235288,
      20,
      51.299564,
      79.480261,
      49,
      NULL,
      72.714300,
      71.654822,
      83,
      14.016860,
      55,
      NULL,
      ' 7- 8-2001',
      12.646868,
      10.019863,
      13.360252,
      NULL,
      14,
      NULL,
      NULL,
      ' 2- 3-2000',
      5,
      2,
      '11-14-1975',
      4.158819,
      9.933690,
      9,
      11.202428,
      4.674665,
      0,
      NULL,
      4.768756,
      NULL,
      46.894448,
      5.557280,
      0.044132,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1- 4-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      68,
      26.371175,
      NULL,
      ' 8-20-1979',
      1.980733,
      200.679170,
      '11-19-1984',
      0,
      12.559323,
      NULL,
      6,
      '10-20-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.776368,
      98.238505,
      87.608443,
      1.707511,
      22.463005,
      2.418740,
      10.118011,
      4,
      13,
      55.331040,
      0.334972,
      1.736021,
      11.393591,
      0,
      0.452658,
      60.372551,
      1.334636,
      2,
      NULL,
      0,
      7,
      NULL,
      12,
      17,
      69,
      1.979301,
      24.359736,
      1,
      1.722156,
      0.191702,
      8,
      1.028612,
      0.634484,
      53,
      86,
      NULL,
      12,
      23,
      3,
      0.064206,
      1.103185,
      18,
      NULL,
      2.945129,
      5.258223,
      NULL,
      0.211847,
      11,
      NULL,
      NULL,
      1.003905,
      1,
      30,
      30,
      15,
      1.239292,
      69,
      NULL,
      27.760060,
      52,
      9.259386,
      4.377817,
      4,
      NULL,
      NULL,
      1,
      1,
      0,
      95,
      ' 8- 1-1983',
      ' 2-12-1975',
      ' 6-17-1989',
      ' 1- 9-1998',
      NULL,
      ' 5-27-1976',
      ' 4-27-1983',
      NULL);
commit;
end;
/


