set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8935013';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '33443111',
      '11304030',
      NULL,
      '13042342',
      '24443433',
      NULL,
      '24424240',
      '11301011',
      '31112214',
      '02041141',
      NULL,
      '42344121',
      NULL,
      '11142104',
      NULL,
      NULL,
      '24221214',
      '41003240',
      '01143013',
      NULL,
      NULL,
      '11341143',
      '41014323',
      '31114224',
      '34131223',
      NULL,
      '01420414',
      '22123432',
      '34301010',
      '14123423',
      '11334440',
      '11020021',
      NULL,
      NULL,
      '43401421',
      '13303333',
      '12232332',
      '34140022',
      '12211113',
      '20234411',
      NULL,
      NULL,
      '03421411',
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      0.262541,
      47.124842,
      2,
      NULL,
      '414010',
      1,
      ' 8-14-1974',
      ' 1- 5-1984',
      38.364959,
      NULL,
      NULL,
      6.698419,
      15.661250,
      15,
      NULL,
      NULL,
      NULL,
      10,
      32,
      1.753036,
      22,
      6.512432,
      7.277851,
      0.276926,
      10,
      3.306873,
      39.372176,
      0.656630,
      NULL,
      7,
      30.765323,
      6.176076,
      NULL,
      71,
      103.556604,
      NULL,
      40,
      NULL,
      NULL,
      '11-14-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.680695,
      0.155349,
      NULL,
      0.875366,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.473703,
      0.554528,
      1.522950,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-27-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14.488171,
      4.524693,
      NULL,
      24.335736,
      22.278480,
      75.560879,
      69.883662,
      22.142431,
      NULL,
      NULL,
      54.588288,
      68,
      ' 7- 3-1974',
      11,
      19.048057,
      1,
      20.364613,
      59,
      71.785026,
      NULL,
      ' 9- 1-1992',
      12.113991,
      18,
      ' 0-16-1996',
      8.511802,
      NULL,
      8,
      NULL,
      NULL,
      4.823344,
      NULL,
      NULL,
      NULL,
      50,
      1,
      1,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      24.835724,
      27,
      NULL,
      ' 8-19-2000',
      NULL,
      NULL,
      ' 7-11-1987',
      NULL,
      NULL,
      7,
      42.991270,
      ' 8- 2-1999',
      NULL,
      NULL,
      NULL,
      ' 9-29-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      0.328968,
      88,
      90.016235,
      NULL,
      81,
      7.718583,
      NULL,
      8,
      16,
      12.724751,
      31,
      0,
      1,
      NULL,
      0,
      1,
      7.437365,
      1.011539,
      1.790636,
      71.887747,
      1,
      1.743560,
      147.541218,
      NULL,
      8.044971,
      57,
      NULL,
      69,
      1,
      NULL,
      1.161234,
      6,
      1,
      1,
      40,
      100.464010,
      19.411288,
      7.912032,
      1,
      108.259830,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      109,
      1.589507,
      1,
      NULL,
      29,
      1,
      15.107669,
      95,
      99,
      NULL,
      NULL,
      11,
      2,
      0.847001,
      6,
      0,
      1,
      1,
      1,
      NULL,
      ' 0-15-1990',
      ' 4- 1-1986',
      ' 6-29-2001',
      NULL,
      ' 8-25-2002',
      NULL,
      NULL,
      NULL);
commit;
end;
/


