set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8935013';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0123',
      '32243303',
      '32411423',
      '44004423',
      '04114214',
      NULL,
      '02402221',
      '34222024',
      '31440034',
      '00142220',
      '23324044',
      NULL,
      '44321423',
      '14303003',
      '03113030',
      NULL,
      NULL,
      '30114404',
      NULL,
      NULL,
      '32131104',
      '12432424',
      '02030333',
      '30204240',
      '12302032',
      '04010113',
      '44413310',
      '04443114',
      '02131004',
      '04222132',
      '23324022',
      '24113111',
      '30023344',
      NULL,
      NULL,
      '44400120',
      '04334120',
      '43042113',
      NULL,
      '02043030',
      '22303340',
      '41030112',
      '21204224',
      '21321133',
      '12043042',
      '133',
      NULL,
      NULL,
      NULL,
      '2212213',
      1.537074,
      NULL,
      NULL,
      NULL,
      '000224',
      0.892979,
      ' 7- 3-1983',
      '10-20-1981',
      127.568756,
      NULL,
      6,
      17,
      13,
      7.027706,
      NULL,
      NULL,
      3,
      7.420481,
      17.165125,
      NULL,
      11.089076,
      15.292263,
      23.215799,
      15,
      19,
      13,
      13.314779,
      6.532688,
      NULL,
      NULL,
      89.155013,
      14,
      0.594944,
      11.135252,
      72,
      9.137682,
      122,
      NULL,
      62,
      ' 2-29-1997',
      9,
      23,
      NULL,
      10.153609,
      30,
      145.784637,
      NULL,
      NULL,
      0,
      1,
      1.332510,
      0.061526,
      0.168356,
      NULL,
      1.078972,
      0.982056,
      1,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      1.500675,
      1.393578,
      NULL,
      0.130490,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-28-1987',
      79,
      NULL,
      6,
      4.464680,
      1.011015,
      NULL,
      ' 1- 0-1980',
      NULL,
      2.993586,
      109.645868,
      NULL,
      1.708502,
      NULL,
      0.803868,
      0.146983,
      28,
      NULL,
      NULL,
      NULL,
      ' 2-20-2000',
      60.149150,
      5,
      57,
      54,
      NULL,
      7.368743,
      33.917405,
      65,
      29.738018,
      55.129856,
      8,
      60.296683,
      NULL,
      20,
      18.080703,
      8.687829,
      17,
      NULL,
      46,
      1.678478,
      ' 2- 2-1980',
      10,
      21,
      ' 6-15-1974',
      8,
      NULL,
      4,
      15,
      5,
      11,
      0.972947,
      NULL,
      0.640591,
      50,
      1.664384,
      0.527388,
      NULL,
      5,
      NULL,
      NULL,
      0.846863,
      NULL,
      ' 7-24-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      69,
      4,
      '10-18-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1- 6-1987',
      NULL,
      ' 7-25-1976',
      4,
      16,
      ' 3-22-1994',
      58,
      39.089279,
      ' 9-15-1979',
      NULL,
      0.383231,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      11.016290,
      ' 5-26-1989',
      44.911085,
      18.318452,
      1.726617,
      NULL,
      0,
      NULL,
      ' 7-29-1994',
      NULL,
      14.643998,
      19,
      23.172828,
      NULL,
      10.613557,
      NULL,
      9.932985,
      ' 1- 9-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


