set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9038203';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3114',
      '40040440',
      '00423214',
      '32021303',
      '30122442',
      '21021021',
      '44214341',
      NULL,
      '42302100',
      '00123313',
      '23430440',
      '14010442',
      '14303414',
      '04443213',
      '43030120',
      '43123121',
      '22120333',
      '43300121',
      '01143031',
      '41340202',
      '20404220',
      '34343412',
      NULL,
      '14231231',
      '00104112',
      '33444204',
      '11420300',
      '43423121',
      '34301413',
      NULL,
      '04422400',
      '43111212',
      '31422100',
      '42214023',
      '12340240',
      '02330233',
      '21411043',
      '10442001',
      NULL,
      '34143314',
      '31200031',
      '13010022',
      '10031331',
      '22310044',
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      '1321443',
      3,
      0,
      2,
      NULL,
      '114134',
      2,
      ' 4-12-2001',
      ' 3-27-1996',
      69.841736,
      NULL,
      1.349325,
      0.987898,
      25.283055,
      NULL,
      NULL,
      NULL,
      8,
      1,
      NULL,
      2,
      13.524548,
      5,
      19.936365,
      12,
      4.225259,
      1,
      42,
      3,
      NULL,
      NULL,
      34.914263,
      2.761529,
      NULL,
      69.891169,
      NULL,
      NULL,
      120,
      26,
      7.648640,
      ' 7- 5-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      8.754154,
      12,
      NULL,
      NULL,
      NULL,
      NULL,
      0.413071,
      NULL,
      0,
      NULL,
      1.367926,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-17-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-10-1993',
      37.266355,
      NULL,
      82.315802,
      83,
      69,
      NULL,
      46.792872,
      63.569861,
      22.522965,
      62,
      45.383457,
      57.362397,
      ' 4-23-1980',
      6,
      NULL,
      4,
      1,
      2.309686,
      4.844800,
      1,
      NULL,
      0,
      1.608926,
      ' 5-28-1980',
      5,
      4.554775,
      NULL,
      7.611928,
      5.715664,
      NULL,
      NULL,
      NULL,
      NULL,
      17,
      0,
      0,
      7.140926,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      61,
      1.701352,
      5.693466,
      ' 9-28-1994',
      NULL,
      NULL,
      '10-16-1980',
      NULL,
      102,
      9,
      1,
      ' 5-10-1981',
      NULL,
      0.316464,
      75,
      '10- 1-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.865132,
      NULL,
      47,
      84,
      88.468095,
      38.873989,
      54.151293,
      24.350589,
      3.835082,
      56.289528,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      109.026740,
      NULL,
      24,
      138,
      23,
      13,
      43.570223,
      0.297278,
      67,
      6.624355,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      18,
      9,
      49.512505,
      1,
      NULL,
      40.288392,
      NULL,
      25,
      26,
      0,
      5,
      1.817334,
      0.222557,
      NULL,
      16.800484,
      NULL,
      12,
      0.418429,
      0,
      21.456927,
      0,
      NULL,
      15.094155,
      63.390634,
      NULL,
      9.914530,
      41,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-28-1989',
      NULL,
      ' 9- 1-1980',
      NULL,
      '10-21-2000',
      ' 3-13-1995',
      NULL,
      NULL);
commit;
end;
/


