set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9008699';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4344',
      NULL,
      '20144333',
      '12003412',
      '32422322',
      '01211344',
      NULL,
      '41312313',
      '10431110',
      '21334031',
      '11301144',
      '13342123',
      '13012433',
      '12440344',
      '41321020',
      '14302023',
      NULL,
      '24240112',
      '12411121',
      '23202422',
      NULL,
      '43410012',
      '33033020',
      NULL,
      '10401144',
      NULL,
      '40133401',
      '20242142',
      '13030440',
      '44433322',
      '42122404',
      '43004011',
      '10241003',
      '33122400',
      '02224033',
      NULL,
      NULL,
      '34341324',
      '42022011',
      '13442410',
      '43342214',
      '44144214',
      '11142433',
      '31411322',
      '13403202',
      '',
      '',
      NULL,
      NULL,
      '4041414',
      3,
      0.166367,
      1,
      NULL,
      '203234',
      NULL,
      NULL,
      ' 7- 1-1988',
      NULL,
      NULL,
      NULL,
      4.781808,
      17.133605,
      NULL,
      81,
      4.070007,
      10,
      7,
      35.794415,
      0,
      35,
      14.943274,
      NULL,
      11.676362,
      0.739668,
      17.103802,
      NULL,
      19.363346,
      5.461524,
      12,
      142,
      9.512358,
      NULL,
      39,
      NULL,
      NULL,
      70,
      218.459600,
      113,
      ' 1- 2-2001',
      9,
      48,
      29.503895,
      NULL,
      159,
      12,
      ' 7-27-1981',
      3,
      5.536448,
      NULL,
      0.280470,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.533630,
      2,
      0.140558,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-17-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-21-1993',
      18.450003,
      3.853515,
      40,
      89,
      66.525433,
      142.564046,
      84.016609,
      15,
      86.550730,
      NULL,
      70.229998,
      72,
      NULL,
      22.571171,
      1,
      NULL,
      79.365902,
      24,
      152.260962,
      NULL,
      '11-29-1978',
      11.630766,
      15.019597,
      ' 6-14-1985',
      11.244094,
      12.540062,
      10.128846,
      8,
      17,
      NULL,
      NULL,
      7.005109,
      NULL,
      86,
      19.585592,
      2.257887,
      6.105791,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-11-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      70.124857,
      10.560248,
      10.540050,
      ' 3-23-2001',
      NULL,
      64,
      NULL,
      14,
      25,
      6,
      12,
      ' 5-26-1978',
      58.504173,
      NULL,
      44,
      ' 7-17-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      86,
      1,
      NULL,
      NULL,
      51.981531,
      0.969206,
      3,
      NULL,
      8.858130,
      10.457275,
      NULL,
      NULL,
      1,
      37.196345,
      1.334086,
      0.997022,
      58.576977,
      0.543959,
      NULL,
      85.924040,
      0,
      NULL,
      70.162030,
      NULL,
      33,
      NULL,
      0,
      NULL,
      1.378115,
      1,
      NULL,
      2,
      0.669166,
      1.083280,
      NULL,
      NULL,
      NULL,
      19.743112,
      NULL,
      NULL,
      16,
      0.850889,
      4,
      1.035872,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.634569,
      1,
      NULL,
      8,
      1,
      5,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      2.058160,
      1.584602,
      0,
      0.953653,
      0.476370,
      NULL,
      '10- 0-1982',
      '11-16-1974',
      '11-18-1974',
      NULL,
      NULL,
      ' 7- 4-1990',
      ' 2-11-1982',
      NULL);
commit;
end;
/


