set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9537284';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      NULL,
      '2',
      '2',
      NULL,
      '0',
      NULL,
      '1',
      '1',
      '3',
      '1',
      '3',
      '1',
      '4',
      '3',
      '4',
      '3',
      '1',
      NULL,
      '4',
      '0',
      '4',
      '0',
      NULL,
      '',
      '2',
      '',
      '4',
      NULL,
      NULL,
      '3',
      '2',
      '',
      '',
      NULL,
      '1',
      '3',
      '0',
      '2',
      '0',
      NULL,
      '0',
      '3',
      '1',
      '0',
      NULL,
      '31143412',
      NULL,
      NULL,
      '1213322',
      0.332936,
      NULL,
      0,
      NULL,
      NULL,
      4,
      ' 5- 9-1981',
      ' 4- 9-1986',
      10.302891,
      84.624532,
      29,
      25.370656,
      20.963658,
      22.462352,
      97,
      32.909452,
      26.345101,
      13.285740,
      43.598114,
      22.521740,
      41.969221,
      7.127021,
      14,
      27.454954,
      22.166592,
      1,
      41,
      17,
      8,
      NULL,
      91,
      12.306267,
      1.224230,
      149,
      182,
      36.809572,
      NULL,
      87,
      NULL,
      NULL,
      58.632752,
      29,
      26.142541,
      6,
      161.720023,
      38,
      ' 0-15-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      23,
      6.220796,
      NULL,
      5,
      8.047361,
      ' 2-20-1979',
      1,
      1,
      227.603472,
      0,
      0.688496,
      76,
      1.289255,
      0,
      119.454053,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      47,
      NULL,
      105,
      8,
      18,
      NULL,
      24,
      73,
      62,
      43,
      NULL,
      ' 4-11-1977',
      20,
      13.153314,
      38,
      6.476428,
      51.469552,
      173.778740,
      NULL,
      ' 6- 8-2001',
      NULL,
      7,
      NULL,
      9,
      4,
      8,
      6,
      9,
      13,
      1,
      9.432273,
      NULL,
      40.032132,
      1.007405,
      1.896976,
      5.187176,
      NULL,
      13.814194,
      1.509535,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      49,
      8.678220,
      ' 7-16-1980',
      NULL,
      NULL,
      NULL,
      2,
      ' 4- 5-2003',
      NULL,
      ' 8-18-1979',
      9.491192,
      3,
      ' 9- 6-1977',
      NULL,
      76,
      ' 5- 1-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      13,
      ' 6-24-1996',
      0.467949,
      9,
      41.594052,
      ' 0-12-1983',
      0,
      NULL,
      '11-28-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


