set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8629216';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4243',
      '33214400',
      '40333321',
      NULL,
      '20422314',
      '43440042',
      '12442442',
      '02131233',
      '22340131',
      '13200312',
      '21033304',
      '21120430',
      '03323311',
      '10230041',
      NULL,
      '11221442',
      '34424430',
      '00101222',
      NULL,
      '31411113',
      '02212302',
      NULL,
      NULL,
      '41441443',
      '23103134',
      '42003113',
      '01430041',
      '24021013',
      '10343010',
      '30002100',
      NULL,
      '21341044',
      NULL,
      '41023033',
      NULL,
      '21000210',
      '32313023',
      '30043100',
      '43302234',
      '20033402',
      NULL,
      '30432331',
      '40344342',
      '43004121',
      '23001021',
      '',
      '',
      NULL,
      NULL,
      '2104213',
      1,
      1,
      1,
      NULL,
      '342021',
      2.883086,
      ' 0-18-2003',
      ' 5-22-1974',
      59,
      NULL,
      19,
      25,
      35.202792,
      1.123041,
      43,
      16.521039,
      NULL,
      23.444453,
      8,
      7.297079,
      30,
      NULL,
      NULL,
      0.163232,
      41,
      NULL,
      NULL,
      0,
      NULL,
      0,
      77.316045,
      0.646085,
      NULL,
      NULL,
      58,
      NULL,
      164,
      252.467978,
      222,
      NULL,
      70.420110,
      NULL,
      28,
      6,
      131,
      149.946193,
      ' 1- 4-1994',
      0.252624,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.467227,
      0.054400,
      0,
      0,
      1.689953,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      95,
      NULL,
      66.613669,
      116,
      NULL,
      33.019291,
      123.115056,
      115.224280,
      NULL,
      49,
      54,
      118.484033,
      ' 2- 1-1988',
      9,
      5,
      12.115802,
      79.320156,
      61.845303,
      157,
      7,
      NULL,
      0,
      22,
      ' 4-23-1976',
      2.501251,
      8,
      25.066433,
      NULL,
      25.045399,
      18.366348,
      NULL,
      12.965655,
      NULL,
      7.876403,
      NULL,
      10,
      17,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-14-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      22,
      12,
      45,
      '10-15-1987',
      NULL,
      9.887656,
      ' 0-10-1991',
      13.465740,
      3,
      NULL,
      19,
      ' 1-24-1985',
      49,
      0,
      131.842055,
      ' 6-27-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      1.971642,
      1,
      NULL,
      NULL,
      27,
      11,
      8.196417,
      4,
      2,
      2,
      NULL,
      3.561673,
      1.462182,
      33,
      NULL,
      NULL,
      45,
      1,
      1,
      64.214194,
      0,
      0.408615,
      17.766147,
      NULL,
      26.411509,
      NULL,
      1,
      NULL,
      NULL,
      1.038717,
      0,
      1.289421,
      0,
      0,
      NULL,
      NULL,
      NULL,
      19.138401,
      NULL,
      NULL,
      1,
      0,
      21,
      0.066209,
      1,
      1.849262,
      49.600448,
      0.800908,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      5.794174,
      8.059040,
      0.090130,
      NULL,
      NULL,
      NULL,
      NULL,
      7.402694,
      3,
      0.646706,
      NULL,
      NULL,
      1.424042,
      0.538014,
      3,
      NULL,
      ' 1-17-1976',
      ' 0-16-1974',
      ' 3-15-1974',
      NULL,
      '11-25-1982',
      ' 2-23-1985',
      ' 9-17-1987',
      NULL);
commit;
end;
/


