set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9433079';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1024',
      '10002111',
      '32221102',
      '13134221',
      '31213242',
      NULL,
      '11341234',
      '33314042',
      '33314414',
      NULL,
      NULL,
      '21201233',
      '11024044',
      '44031344',
      '11222314',
      '12201020',
      '04144240',
      '21144340',
      NULL,
      '43002120',
      '42103443',
      '03321443',
      '31120401',
      '32401033',
      '43314042',
      NULL,
      '13343100',
      '43014311',
      NULL,
      NULL,
      '22410402',
      '03322042',
      '42141102',
      '23343112',
      NULL,
      '33434111',
      NULL,
      '23411104',
      '34001402',
      '43044232',
      '42144131',
      '30012331',
      '33103040',
      '21132230',
      '14431144',
      '023',
      NULL,
      NULL,
      NULL,
      '3214243',
      3.370300,
      NULL,
      3,
      NULL,
      '422042',
      1.619503,
      ' 5- 9-1978',
      ' 8-27-1975',
      62.399657,
      NULL,
      3,
      3.997215,
      25.365654,
      14.630869,
      NULL,
      6,
      7,
      6,
      6.096483,
      3,
      2,
      4,
      18.218968,
      10,
      2.286144,
      1,
      NULL,
      0,
      3.914722,
      NULL,
      65.068145,
      7.164926,
      0.353308,
      47.877150,
      NULL,
      2,
      96,
      41.453217,
      106,
      NULL,
      14.973877,
      1,
      0,
      18,
      122.247392,
      106,
      ' 8- 3-1992',
      1,
      NULL,
      2,
      21.120437,
      2.997191,
      29.517273,
      0.313094,
      14,
      NULL,
      0.697126,
      1.298239,
      1,
      1.745256,
      33,
      1.442226,
      1,
      18,
      NULL,
      0.341353,
      2.961084,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-12-1991',
      44,
      9.449491,
      NULL,
      17,
      NULL,
      2.073213,
      '11- 0-1999',
      3.331430,
      0.190069,
      90.943519,
      1,
      NULL,
      13.152042,
      1.201574,
      1,
      18,
      NULL,
      NULL,
      NULL,
      ' 1-20-1989',
      51,
      29,
      23,
      NULL,
      19.324877,
      30.287601,
      93.286505,
      NULL,
      NULL,
      24,
      95.361686,
      21,
      ' 9-26-2003',
      0,
      2,
      4,
      NULL,
      NULL,
      2,
      1.209602,
      '10-29-1986',
      0,
      0.585859,
      ' 4- 5-1983',
      1,
      0,
      11.711051,
      NULL,
      7.035227,
      2,
      0,
      1.045685,
      1,
      17.974385,
      0.388125,
      0.005837,
      5,
      3.552054,
      NULL,
      3,
      3.606627,
      NULL,
      ' 5- 7-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      26.471020,
      27.845241,
      ' 5-11-1974',
      NULL,
      NULL,
      NULL,
      15,
      ' 1-23-2002',
      29,
      ' 1- 9-1987',
      7.001992,
      NULL,
      ' 5-29-1999',
      NULL,
      NULL,
      NULL,
      0,
      2.764391,
      ' 5-19-1981',
      NULL,
      NULL,
      NULL,
      0,
      2,
      10.446836,
      ' 2-13-1981',
      55.646723,
      9,
      6.611675,
      ' 9- 1-1988',
      2,
      356.892783,
      ' 9- 7-1993',
      NULL,
      121.205290,
      0.236209,
      119.079879,
      '11-14-1979',
      NULL,
      NULL,
      172,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


