set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6717343';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2130',
      '44042110',
      '10242140',
      '21044344',
      '20321142',
      '20414242',
      '23410434',
      '00014423',
      '10012323',
      '42331143',
      '34114420',
      NULL,
      '33444213',
      '11421233',
      NULL,
      '14221423',
      '20004440',
      '13223010',
      '21104014',
      '44021213',
      '13200443',
      '41304120',
      '33320133',
      '04333441',
      '20100422',
      NULL,
      '23042323',
      NULL,
      '03003230',
      '41140040',
      '02420232',
      '02331322',
      '04001430',
      '04213404',
      NULL,
      '21132200',
      '32400011',
      '13330213',
      '44003404',
      NULL,
      '41333102',
      '13424332',
      '40224320',
      '32411144',
      '14144442',
      '',
      '',
      NULL,
      NULL,
      '1224442',
      0,
      1,
      1,
      NULL,
      NULL,
      1,
      ' 7- 5-1994',
      NULL,
      67.038667,
      NULL,
      10.730190,
      16,
      NULL,
      12,
      109.000246,
      17,
      5,
      13,
      44.204190,
      6.115678,
      20.949026,
      12,
      0,
      NULL,
      NULL,
      7.943291,
      17.047703,
      3.529435,
      34.808478,
      13,
      39,
      6.427406,
      NULL,
      11,
      170,
      4.637221,
      NULL,
      67.954652,
      4.413520,
      ' 6- 9-1975',
      NULL,
      6,
      NULL,
      17.034558,
      12.848585,
      NULL,
      ' 7- 1-1988',
      3.687870,
      5.380017,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.451609,
      NULL,
      NULL,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-15-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      53.920605,
      NULL,
      NULL,
      71.867067,
      16,
      4,
      100,
      81,
      14,
      46.852240,
      32,
      20.974634,
      ' 4- 5-2000',
      21,
      32.982206,
      22.235054,
      28,
      1,
      145,
      NULL,
      '11-14-1981',
      9,
      0.108367,
      NULL,
      6.707520,
      4,
      8.339060,
      9.649343,
      11.353247,
      13,
      NULL,
      9,
      NULL,
      78,
      0.484421,
      5,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10- 9-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      27.275917,
      NULL,
      25.732583,
      ' 5-21-1993',
      2.685997,
      8.895152,
      ' 9-28-1991',
      12.981672,
      141.749690,
      11,
      77,
      ' 5-21-1977',
      53,
      1,
      258.791148,
      ' 0- 1-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      53,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      65.737553,
      0,
      0.906945,
      96,
      2.862148,
      0,
      67,
      0.406285,
      0.517045,
      17,
      NULL,
      27,
      NULL,
      0.212029,
      NULL,
      NULL,
      1,
      9.767630,
      4.923135,
      2,
      0.927220,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      3,
      0,
      1,
      5.977871,
      9.512223,
      NULL,
      11.097515,
      1,
      NULL,
      1.829011,
      NULL,
      NULL,
      1.819406,
      NULL,
      NULL,
      8,
      8.098942,
      NULL,
      NULL,
      9,
      NULL,
      8.516064,
      2.882598,
      NULL,
      4,
      NULL,
      1,
      1.994995,
      1.213614,
      NULL,
      NULL,
      ' 1-12-2002',
      '10-19-1996',
      ' 9-16-1997',
      ' 6-19-1984',
      ' 9-10-1998',
      NULL,
      NULL);
commit;
end;
/


