set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9036757';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '3',
      '0',
      NULL,
      NULL,
      NULL,
      '2',
      '1',
      '3',
      '1',
      '2',
      '0',
      '2',
      '0',
      '2',
      '4',
      '1',
      '0',
      NULL,
      '0',
      '2',
      '2',
      NULL,
      '1',
      '',
      NULL,
      '',
      NULL,
      '3',
      '3',
      '1',
      '2',
      '',
      '',
      '1',
      '0',
      '2',
      '1',
      '2',
      '1',
      NULL,
      '3',
      '2',
      NULL,
      '3',
      '400',
      '03040401',
      28.525119,
      55,
      '3131304',
      3,
      1.378825,
      NULL,
      0,
      '110444',
      1,
      ' 5-13-1978',
      ' 4- 1-1979',
      257.696764,
      93,
      27,
      9.940921,
      11,
      NULL,
      27,
      NULL,
      NULL,
      11,
      30.837997,
      6,
      23,
      3.076435,
      NULL,
      NULL,
      7,
      2.602241,
      0,
      17.212853,
      NULL,
      9.061702,
      4.448365,
      NULL,
      NULL,
      24,
      94,
      54,
      33,
      125,
      121,
      '11-21-1991',
      3,
      40,
      NULL,
      8.694544,
      NULL,
      162,
      '11- 1-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12,
      6,
      NULL,
      NULL,
      5,
      1.973936,
      '10-12-1979',
      0.455178,
      0.118874,
      86,
      7.007005,
      2.004426,
      NULL,
      0,
      2,
      35,
      NULL,
      NULL,
      NULL,
      ' 9-27-1978',
      6.809936,
      52,
      38,
      40.152999,
      15.994714,
      23.723934,
      NULL,
      21,
      4,
      25.759113,
      66,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      30,
      43,
      32.960886,
      2.470702,
      ' 7-13-1997',
      6,
      2.811429,
      ' 5-12-1997',
      0.584822,
      13,
      NULL,
      4.263125,
      NULL,
      6,
      0.493716,
      NULL,
      0,
      84.684025,
      0.996968,
      NULL,
      NULL,
      NULL,
      1.348556,
      NULL,
      2,
      0.548407,
      '11- 3-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.279585,
      NULL,
      NULL,
      NULL,
      NULL,
      20.956865,
      ' 1-13-2000',
      22,
      '10-16-2000',
      NULL,
      NULL,
      ' 1- 4-1998',
      85.018916,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      '10- 0-1980',
      12,
      28.466126,
      44.472308,
      ' 7-15-1993',
      1,
      23,
      ' 7- 5-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


