set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9758892';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '3',
      '0',
      '1',
      '4',
      '2',
      '1',
      '4',
      NULL,
      '0',
      '1',
      NULL,
      '3',
      '4',
      NULL,
      '0',
      '3',
      '3',
      '2',
      '3',
      '3',
      '1',
      '1',
      NULL,
      '',
      NULL,
      '',
      NULL,
      NULL,
      '2',
      '4',
      NULL,
      '',
      '',
      '3',
      '1',
      '4',
      '4',
      '2',
      '4',
      '1',
      '2',
      '0',
      '2',
      '0',
      '242',
      '41',
      32.151364,
      45.253783,
      '1132404',
      0,
      1.617607,
      2,
      NULL,
      '033342',
      1,
      ' 1-20-1976',
      ' 3-23-2001',
      68.685804,
      181.304573,
      15.832590,
      14.313640,
      1,
      NULL,
      24,
      NULL,
      NULL,
      12,
      NULL,
      10.345598,
      41.880295,
      19,
      NULL,
      NULL,
      8.543384,
      NULL,
      49.382701,
      3.363824,
      2,
      6,
      21.399016,
      2,
      1.194260,
      47,
      118,
      67.721718,
      113.683241,
      NULL,
      95.553978,
      NULL,
      2,
      37.796462,
      19,
      33.182970,
      NULL,
      1.812383,
      ' 6-18-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      4,
      86,
      0,
      1,
      26.107826,
      NULL,
      NULL,
      NULL,
      ' 3-29-1974',
      33,
      NULL,
      59,
      2,
      26,
      20.700290,
      1.158189,
      NULL,
      NULL,
      50,
      48.895996,
      19.627068,
      ' 6- 3-1999',
      0.220484,
      18.952461,
      0.135942,
      30.467002,
      26.929706,
      3,
      2.402201,
      ' 9- 2-1988',
      NULL,
      16,
      '10-17-1999',
      8,
      NULL,
      20.655391,
      NULL,
      8.293080,
      0.432960,
      1,
      NULL,
      NULL,
      23.981192,
      3.254894,
      0,
      8,
      9,
      1,
      NULL,
      NULL,
      0.545270,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      36,
      30,
      ' 0- 1-1997',
      NULL,
      NULL,
      NULL,
      37,
      ' 4- 6-1996',
      NULL,
      NULL,
      14.698034,
      9,
      ' 5-15-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      12.343576,
      ' 6-13-1975',
      32.838168,
      4,
      12,
      NULL,
      3,
      179,
      ' 9- 7-1975',
      9.817504,
      12.830487,
      14.794118,
      100.435201,
      NULL,
      65.242210,
      NULL,
      34,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


