set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8733301';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '02401004',
      '34331410',
      '00041421',
      '22214214',
      NULL,
      NULL,
      '42414033',
      '11200212',
      '10401042',
      '11013001',
      '20224032',
      '10120310',
      '11021403',
      '41141310',
      '11212420',
      NULL,
      '02444441',
      '40203244',
      '22021102',
      '21343133',
      NULL,
      NULL,
      '14021231',
      '41124233',
      '20233114',
      '30400412',
      '31410320',
      '03001021',
      '32320110',
      '42144230',
      '34200340',
      '31401101',
      '11032021',
      '44311322',
      '22012324',
      '43434332',
      '23124001',
      NULL,
      NULL,
      '31221432',
      '11021324',
      NULL,
      '32200310',
      '20200414',
      '',
      '',
      NULL,
      NULL,
      '3232133',
      NULL,
      0.747428,
      3,
      NULL,
      '441030',
      3.087147,
      '10- 7-1974',
      '11-25-1994',
      24.833831,
      NULL,
      NULL,
      5.789814,
      17.771418,
      20.402411,
      21.796226,
      11,
      1,
      9.799141,
      6.311536,
      0,
      11,
      4.462881,
      NULL,
      5,
      13,
      3,
      17,
      0.056346,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      5,
      NULL,
      8.768466,
      NULL,
      119.932545,
      124.326402,
      ' 7- 5-1977',
      33,
      NULL,
      34.000254,
      7.048105,
      51.942592,
      94.074686,
      ' 3-12-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-18-1981',
      38,
      58.414866,
      78.236395,
      62.842301,
      12,
      29,
      NULL,
      10.409753,
      28.384837,
      50,
      33.610598,
      56,
      '11-20-1986',
      13,
      7.438830,
      2,
      32,
      NULL,
      13,
      3,
      ' 2- 8-1990',
      0.053042,
      1.283340,
      ' 6-23-1985',
      NULL,
      10.188821,
      9.225832,
      7.669211,
      20,
      6.134411,
      NULL,
      11,
      NULL,
      23,
      1.274531,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-25-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      39.246639,
      3.272233,
      0,
      NULL,
      1.279299,
      7,
      ' 5-26-2001',
      9,
      36.899700,
      7,
      NULL,
      '10-29-1987',
      11.304910,
      NULL,
      118.964582,
      ' 4-10-2000',
      NULL,
      NULL,
      NULL,
      29.031466,
      NULL,
      NULL,
      NULL,
      NULL,
      107,
      82.972777,
      NULL,
      NULL,
      39.550394,
      6.562974,
      23,
      0.467889,
      1.271958,
      71,
      0.273883,
      NULL,
      1.614640,
      1,
      0,
      87,
      2.335552,
      1.579415,
      193,
      NULL,
      31,
      NULL,
      1,
      32.284023,
      NULL,
      NULL,
      1.592550,
      4,
      NULL,
      1.872408,
      NULL,
      23.484154,
      NULL,
      11.508788,
      NULL,
      4,
      0.236316,
      1,
      12.867465,
      1,
      7.906052,
      1,
      6,
      3.576194,
      16,
      0,
      36.895249,
      1,
      1.642868,
      24,
      6,
      7.458072,
      24.575794,
      27.883780,
      36.237938,
      NULL,
      64.793163,
      9,
      NULL,
      1,
      3,
      0.573915,
      1.427642,
      0,
      NULL,
      55.182333,
      ' 4-24-2003',
      NULL,
      ' 6- 4-1974',
      ' 7-16-1975',
      ' 6- 7-1979',
      ' 0-14-1977',
      ' 6-17-1979',
      NULL);
commit;
end;
/


