set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8733301';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4112',
      '04234431',
      '03314043',
      NULL,
      '13310110',
      '14312414',
      '33201341',
      '24300441',
      '11123344',
      '01141443',
      '01003432',
      '31410434',
      '03030403',
      '33100434',
      '33304304',
      '14044104',
      NULL,
      '20141144',
      NULL,
      '02144111',
      '12222233',
      NULL,
      NULL,
      '34032203',
      '31412220',
      NULL,
      NULL,
      '41224231',
      '41243224',
      '21231043',
      '22442300',
      NULL,
      NULL,
      '43131002',
      '13233404',
      '23021322',
      '00103202',
      '02321333',
      '24424140',
      '31342233',
      '40304344',
      '34430003',
      '31310324',
      NULL,
      '34204121',
      '',
      '',
      NULL,
      NULL,
      '4012120',
      2.897305,
      14.210938,
      2,
      NULL,
      '020043',
      2,
      ' 4-11-1999',
      ' 0- 7-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      45.453950,
      41.754074,
      3.730066,
      4.344744,
      NULL,
      123.504854,
      NULL,
      0.173253,
      2,
      4,
      1.621496,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.708199,
      3.301109,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-24-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11- 7-2001',
      43,
      31,
      59,
      35,
      1,
      25,
      46.990697,
      13,
      14.438796,
      NULL,
      102,
      27,
      ' 4-15-1983',
      10.092707,
      11,
      8,
      21.309628,
      4,
      4.730449,
      NULL,
      ' 9-24-1996',
      6,
      2.346140,
      ' 3- 1-1986',
      1,
      2.125710,
      7,
      NULL,
      NULL,
      2.678693,
      NULL,
      6,
      NULL,
      2.498091,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      61.738788,
      ' 5-14-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      33,
      27,
      1.257574,
      69.503232,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.042115,
      0.962058,
      76.855770,
      2,
      1.629725,
      NULL,
      NULL,
      1,
      115,
      4.867340,
      1.970489,
      152.982382,
      NULL,
      NULL,
      NULL,
      0,
      110,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      113.617704,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.217228,
      17,
      0.508454,
      0.157897,
      0.681892,
      6,
      1.431357,
      62.616985,
      1.145599,
      59.130112,
      0,
      0.788630,
      NULL,
      24,
      12,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      5.180530,
      6.603129,
      1.980520,
      3,
      1,
      NULL,
      58.831536,
      NULL,
      NULL,
      NULL,
      ' 8- 5-1989',
      NULL,
      NULL,
      ' 6-27-1992',
      NULL);
commit;
end;
/


