set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8733301';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1010',
      '34210434',
      NULL,
      '01114001',
      NULL,
      '01001030',
      '31424231',
      '11322344',
      '00403434',
      NULL,
      '20011102',
      '20121042',
      NULL,
      '43211144',
      NULL,
      '02013412',
      '43101422',
      NULL,
      '41312400',
      '34110120',
      '42341131',
      NULL,
      '33013234',
      '04423222',
      '14114241',
      '43443032',
      NULL,
      '21340413',
      '43133032',
      '13311343',
      NULL,
      '43342230',
      NULL,
      '34401240',
      '12101232',
      '20223402',
      '30122221',
      '31343104',
      '40321201',
      NULL,
      '20301134',
      '00334201',
      '31113204',
      '30324021',
      NULL,
      '044',
      '43',
      NULL,
      NULL,
      '2120411',
      1.462589,
      23,
      NULL,
      NULL,
      '043104',
      NULL,
      ' 7-26-2000',
      NULL,
      14.075328,
      NULL,
      5,
      2,
      5.094130,
      0.128403,
      27.282600,
      4.144210,
      16.682674,
      1.083501,
      11.004212,
      9.662123,
      29.525537,
      14.916408,
      24,
      NULL,
      34.926386,
      30,
      36,
      1,
      38,
      2,
      47,
      10.362706,
      3.518582,
      67,
      104.911503,
      82.247065,
      NULL,
      70,
      NULL,
      ' 1- 7-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.401196,
      5.480608,
      0.160593,
      5.535125,
      1.016890,
      NULL,
      1,
      0,
      1.264900,
      4.245337,
      NULL,
      1.812877,
      0,
      1,
      0,
      3.129207,
      0.480574,
      1.793998,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-12-1980',
      1,
      54,
      8.777040,
      2.872887,
      21,
      1.534986,
      ' 9-11-1983',
      1,
      0.951899,
      9,
      0.297993,
      0.953389,
      85,
      0.346492,
      1,
      61,
      NULL,
      1,
      72.274571,
      NULL,
      3,
      1.388687,
      59.316131,
      50.016941,
      71,
      59,
      7.665264,
      86.282470,
      50.712206,
      39,
      NULL,
      27,
      ' 2-12-1986',
      4.063954,
      17.976932,
      13.480778,
      NULL,
      29.329045,
      20.870651,
      3.070494,
      ' 9-12-1999',
      NULL,
      NULL,
      ' 5-11-1992',
      0,
      8.270094,
      5.280813,
      NULL,
      NULL,
      2,
      1.169001,
      14.127326,
      1.277858,
      44.603237,
      3,
      3,
      NULL,
      21.232481,
      NULL,
      9,
      0.510720,
      1,
      ' 7- 5-2003',
      1,
      1.988861,
      NULL,
      ' 6-14-1981',
      NULL,
      2.758210,
      '10- 2-2000',
      NULL,
      NULL,
      NULL,
      37,
      ' 9-27-1983',
      15.787530,
      ' 5-11-1980',
      NULL,
      2.312463,
      ' 7-14-1986',
      5,
      14.770250,
      ' 5-16-1982',
      3,
      2,
      '10-20-1988',
      2,
      5.623407,
      ' 8-21-1998',
      NULL,
      2,
      11,
      ' 7-13-1995',
      46,
      4.378470,
      14.179739,
      ' 3-18-1981',
      0,
      223,
      '10-27-2000',
      14.545381,
      21.887012,
      2.410681,
      37,
      ' 9-17-1996',
      44.691775,
      0.580052,
      NULL,
      '10-18-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6);
commit;
end;
/


