set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8733301';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1433',
      '34313423',
      '04420122',
      '00323321',
      '40100324',
      NULL,
      NULL,
      '13432314',
      NULL,
      '30234312',
      '12412441',
      '34013442',
      '20214421',
      '11011330',
      '33123103',
      '34410334',
      '40210311',
      NULL,
      '02204222',
      NULL,
      '12311324',
      '41421430',
      '01114303',
      NULL,
      '41324344',
      '23144300',
      '11240210',
      '43104321',
      '44342220',
      NULL,
      '43122432',
      '40344211',
      '24423313',
      '31244114',
      '14041041',
      '14444134',
      '32414413',
      '11243124',
      NULL,
      '00104300',
      NULL,
      '34231343',
      '01413040',
      '02023202',
      '13233104',
      '004',
      '21',
      NULL,
      3,
      '0314414',
      1,
      208,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-11-2001',
      ' 7-13-1992',
      NULL,
      40,
      4,
      NULL,
      23,
      NULL,
      NULL,
      4,
      NULL,
      19,
      3,
      2.805095,
      NULL,
      5,
      26.839412,
      3,
      9.182254,
      15,
      NULL,
      4,
      27.449949,
      NULL,
      41.518156,
      2,
      NULL,
      18,
      117.450427,
      6.114437,
      NULL,
      95,
      119.974581,
      '11-21-1982',
      6,
      3.035464,
      16,
      15.820040,
      81.842417,
      24.573924,
      ' 3-17-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      16.647786,
      62,
      25.262410,
      36.253600,
      44,
      1,
      NULL,
      1.794611,
      3.336880,
      76,
      1,
      1.382410,
      NULL,
      0,
      0.503878,
      33.087158,
      NULL,
      NULL,
      NULL,
      ' 4- 4-1978',
      5.688901,
      24,
      1,
      115.288546,
      71,
      27.651329,
      NULL,
      62.807584,
      9.567952,
      14,
      5.329180,
      14,
      ' 9-13-1996',
      5.293371,
      10.242524,
      3,
      24.605760,
      59,
      41,
      5,
      ' 7- 4-2003',
      2,
      2,
      ' 4- 0-1992',
      NULL,
      10.041814,
      19.675221,
      6,
      2.400046,
      NULL,
      0.011257,
      14.054689,
      1,
      NULL,
      1.561051,
      NULL,
      16.342940,
      31.174891,
      0,
      NULL,
      NULL,
      NULL,
      ' 3-11-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.664471,
      ' 7-18-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      39,
      ' 2- 0-1978',
      NULL,
      10,
      ' 4-20-1980',
      60,
      33,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      32.392492,
      27.578912,
      7.695679,
      ' 9-26-1978',
      2.044437,
      148.519939,
      NULL,
      2,
      NULL,
      NULL,
      7,
      ' 9-15-1993',
      24.308296,
      0,
      183.328438,
      ' 2- 6-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


