set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8733301';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '1',
      '3',
      '2',
      '0',
      '0',
      '2',
      NULL,
      '0',
      '1',
      NULL,
      NULL,
      '1',
      NULL,
      '0',
      '3',
      '2',
      '0',
      '0',
      '2',
      '3',
      '0',
      '2',
      '3',
      '',
      '0',
      '',
      '4',
      '4',
      '4',
      NULL,
      '0',
      '',
      '',
      '0',
      '0',
      '0',
      '2',
      '1',
      '3',
      '3',
      '4',
      '0',
      '3',
      '1',
      NULL,
      '03024014',
      25.852642,
      34,
      '2340321',
      NULL,
      109.183304,
      NULL,
      NULL,
      '003220',
      5,
      NULL,
      NULL,
      22.607588,
      125.791903,
      31,
      6,
      5.549279,
      NULL,
      38,
      13,
      NULL,
      3,
      11,
      NULL,
      16.145601,
      NULL,
      26,
      0.684765,
      8,
      2,
      18.078916,
      9,
      NULL,
      NULL,
      34.122372,
      7,
      1,
      42,
      82.732518,
      30.504687,
      4,
      NULL,
      5.625272,
      NULL,
      13.264286,
      NULL,
      17,
      0.283906,
      18,
      159,
      ' 4-29-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      30.148394,
      58.300559,
      74,
      NULL,
      55.732634,
      1,
      ' 1-17-1978',
      1,
      NULL,
      NULL,
      0.673524,
      0.252416,
      2.695727,
      NULL,
      0,
      55,
      NULL,
      NULL,
      NULL,
      ' 1-13-1976',
      108.719659,
      80,
      99.456277,
      11,
      29.116456,
      81.376362,
      75.275109,
      87.301863,
      NULL,
      35.739546,
      NULL,
      72,
      ' 8- 1-1988',
      0.184197,
      3,
      19.999816,
      22,
      NULL,
      28,
      8,
      '10-29-1974',
      15.661436,
      12,
      ' 0-27-1984',
      3,
      15.881740,
      4,
      NULL,
      7,
      0.024868,
      1,
      4,
      NULL,
      29.385918,
      0.237942,
      0,
      6,
      29.344688,
      0,
      0,
      3.329083,
      1,
      ' 5-23-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      34.018739,
      18,
      ' 1-15-1979',
      NULL,
      NULL,
      NULL,
      31.750938,
      '10-24-1992',
      39.101914,
      ' 2- 5-1975',
      11.923188,
      7,
      ' 7-18-2000',
      108,
      16,
      ' 8-11-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      4,
      NULL,
      33,
      NULL,
      7.379017,
      ' 0-26-1983',
      1.957961,
      126.802204,
      ' 3- 9-1985',
      0,
      60.764694,
      NULL,
      NULL,
      ' 2-18-1997',
      42,
      1.513223,
      30,
      ' 1- 4-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


