set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9232524';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2342',
      NULL,
      '00231144',
      '23342233',
      '43310344',
      '21404441',
      '33220434',
      NULL,
      '34341411',
      '44334432',
      '04223332',
      '24011210',
      NULL,
      NULL,
      '40103434',
      '00330333',
      '11121221',
      NULL,
      NULL,
      '22130111',
      '23211403',
      '11134231',
      '02214001',
      '34304243',
      '42042324',
      '43043041',
      '31430420',
      '20210343',
      '20420400',
      '03143330',
      '44412000',
      NULL,
      '41011402',
      NULL,
      NULL,
      '03212030',
      '44013003',
      '34143201',
      '23430102',
      '32432221',
      NULL,
      '34113214',
      '42302401',
      '23410130',
      '44241034',
      '013',
      '24',
      NULL,
      7.167242,
      '1233220',
      3.066608,
      NULL,
      NULL,
      NULL,
      '032101',
      3,
      ' 6-15-1978',
      ' 8-10-1981',
      74.721702,
      21.148259,
      27,
      8.886710,
      2.970492,
      1.130213,
      17,
      NULL,
      12.938846,
      15,
      NULL,
      0.204766,
      22,
      1.057182,
      7,
      4.160302,
      2,
      NULL,
      47,
      5.803424,
      17,
      18.794640,
      15.765461,
      14,
      NULL,
      55,
      100.502882,
      77.375158,
      40,
      133,
      138.580139,
      ' 3- 5-2003',
      16.521740,
      25,
      24,
      28,
      154,
      62,
      ' 4-26-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      55.038307,
      14,
      15,
      7.583375,
      15,
      0.343878,
      '10-20-1986',
      1,
      0.295893,
      123.350022,
      0,
      1,
      29.826050,
      1.656283,
      1,
      17.315016,
      NULL,
      NULL,
      NULL,
      ' 1- 2-1974',
      NULL,
      8,
      NULL,
      63,
      NULL,
      92,
      NULL,
      73,
      60,
      10,
      26.505819,
      94,
      ' 9-28-1985',
      12,
      6,
      2.605235,
      1.292218,
      25,
      1,
      2.229747,
      ' 2-17-1988',
      2,
      4.106042,
      ' 4- 2-1974',
      5.207070,
      4.955323,
      6,
      11.426599,
      12.224411,
      5,
      NULL,
      4,
      0,
      NULL,
      1,
      2,
      4,
      6.126018,
      5,
      NULL,
      0.942498,
      1,
      ' 1-19-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      19.341550,
      3.968024,
      ' 3-18-1992',
      NULL,
      NULL,
      NULL,
      3,
      ' 1-21-2001',
      NULL,
      ' 2- 3-1984',
      3.583408,
      1.669891,
      ' 5- 4-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      '11- 0-1999',
      8,
      28,
      30,
      '10-14-1991',
      1,
      125,
      '10- 2-1985',
      0.053340,
      46.811655,
      7,
      27,
      '10-24-1991',
      39.186493,
      NULL,
      278.564813,
      ' 9-26-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


