set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9232524';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1324',
      '03020314',
      '40014102',
      '22314031',
      NULL,
      '33411024',
      '21331120',
      NULL,
      '24023011',
      '22212234',
      '34304100',
      '01042130',
      '32311113',
      NULL,
      NULL,
      '14221303',
      NULL,
      NULL,
      '20443321',
      NULL,
      NULL,
      NULL,
      NULL,
      '22140121',
      '01323402',
      '31421004',
      '03241302',
      '33201142',
      '41002344',
      '41243232',
      NULL,
      NULL,
      '00020010',
      '21221302',
      '23344401',
      '13402432',
      NULL,
      '24324240',
      '04242411',
      '14012402',
      '33432232',
      '31000234',
      NULL,
      '23131412',
      NULL,
      '440',
      NULL,
      43.818933,
      16.847576,
      '0331240',
      1.828352,
      22,
      2,
      NULL,
      '302300',
      4.435962,
      ' 6-21-2003',
      ' 9- 6-1990',
      NULL,
      132,
      12,
      15,
      13.873975,
      NULL,
      18.505474,
      11.004836,
      NULL,
      NULL,
      11.021317,
      2,
      27.033875,
      NULL,
      24.026713,
      NULL,
      2.572388,
      NULL,
      47.745664,
      11.645616,
      38,
      0,
      NULL,
      11,
      NULL,
      17.925209,
      21,
      37.249492,
      0,
      NULL,
      20,
      ' 3-27-1991',
      NULL,
      38,
      5.030929,
      16,
      128.804711,
      187,
      '11-15-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      98.239988,
      12.505844,
      5,
      NULL,
      NULL,
      9.512310,
      ' 7-13-1998',
      NULL,
      1.549235,
      NULL,
      2.223242,
      NULL,
      44.504953,
      0.630759,
      1.190737,
      24,
      NULL,
      NULL,
      NULL,
      ' 8- 4-1985',
      115,
      NULL,
      NULL,
      99.770308,
      46,
      7.055330,
      NULL,
      32.287692,
      85,
      90.574572,
      81,
      76,
      NULL,
      7,
      3,
      6,
      2,
      1.029728,
      1.637910,
      0,
      ' 0- 3-1975',
      10,
      22,
      NULL,
      NULL,
      11.045786,
      1,
      6,
      23.076719,
      4.576997,
      0.418742,
      9.689572,
      0,
      69,
      NULL,
      NULL,
      15.924839,
      8,
      1.331949,
      1,
      NULL,
      NULL,
      ' 3-25-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.175992,
      ' 6- 2-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6- 8-2002',
      16.475487,
      '11-18-1997',
      2.161618,
      14.406724,
      ' 6- 2-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      ' 6-16-1992',
      51,
      3,
      5.105597,
      NULL,
      1,
      NULL,
      ' 5- 3-1991',
      2.848088,
      100.577952,
      6.205575,
      21.547485,
      ' 0- 6-1978',
      NULL,
      NULL,
      162.627118,
      ' 9- 6-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


