set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9232524';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '2',
      '4',
      '3',
      NULL,
      NULL,
      '4',
      '4',
      '2',
      '4',
      '0',
      '0',
      '1',
      NULL,
      '3',
      NULL,
      NULL,
      '3',
      '3',
      '2',
      '0',
      '0',
      NULL,
      '4',
      '',
      NULL,
      NULL,
      '0',
      '2',
      '1',
      '3',
      NULL,
      '',
      '',
      '0',
      '3',
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      NULL,
      '0',
      '3',
      '1',
      '343',
      '43220414',
      21.803782,
      20,
      '4241241',
      2.910914,
      72,
      3,
      NULL,
      '220224',
      NULL,
      ' 0- 0-1978',
      ' 8- 6-1982',
      NULL,
      112.424194,
      1,
      NULL,
      9.883141,
      7,
      62,
      2,
      0,
      NULL,
      28.518074,
      6,
      NULL,
      NULL,
      15.692072,
      5.436482,
      25,
      15.149860,
      2.450855,
      4,
      23.766973,
      3,
      62.990197,
      NULL,
      NULL,
      4.169552,
      45.554877,
      80,
      34.467077,
      47.682633,
      164,
      ' 1-15-2003',
      NULL,
      24,
      9,
      1.980857,
      148.012920,
      5.410947,
      '10-17-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      16,
      7.611539,
      2.052676,
      NULL,
      9.802648,
      ' 9- 7-1978',
      1.796276,
      NULL,
      7.253298,
      0,
      1.286608,
      82,
      1.150869,
      1.509380,
      69,
      NULL,
      NULL,
      NULL,
      ' 7- 8-1996',
      19.621639,
      2,
      108,
      2,
      NULL,
      78,
      52,
      NULL,
      79,
      69.938535,
      NULL,
      28.427495,
      ' 6-16-1993',
      1.015902,
      4,
      1,
      0,
      18,
      NULL,
      1.255219,
      NULL,
      20,
      15,
      ' 6-24-1997',
      13,
      7,
      9.339646,
      6.545177,
      NULL,
      NULL,
      1,
      2,
      0,
      56.757431,
      1,
      NULL,
      5.480970,
      5,
      0,
      0.665239,
      0.498664,
      NULL,
      ' 7-17-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      45,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      23.077313,
      '10-19-2001',
      NULL,
      ' 5-26-1988',
      10,
      7.756212,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      9,
      NULL,
      50.773364,
      NULL,
      27.603148,
      ' 2-12-1978',
      1.409328,
      19,
      ' 5- 4-1982',
      NULL,
      57,
      15.324633,
      63,
      ' 4-28-1988',
      58.044127,
      0,
      NULL,
      ' 2-12-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


