set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9200587';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '30342400',
      '41424412',
      '13432010',
      '20242003',
      '23204304',
      '14043311',
      '21320413',
      '24312421',
      '34323042',
      NULL,
      NULL,
      NULL,
      '41030013',
      '31313041',
      '22001232',
      '04100443',
      '03214430',
      NULL,
      '32434442',
      NULL,
      '44412444',
      '23344311',
      '30243114',
      '44200213',
      '12430310',
      '32210121',
      '21004022',
      '44112243',
      '33043233',
      '10112301',
      '40242102',
      '42431342',
      NULL,
      '03403144',
      '22110113',
      '34240303',
      NULL,
      '34211313',
      '34111332',
      '42132121',
      '11041434',
      NULL,
      '24024434',
      NULL,
      '342',
      NULL,
      NULL,
      NULL,
      '3114400',
      0,
      1,
      3,
      NULL,
      '342400',
      4,
      '11- 2-1999',
      '10-23-1974',
      35.320404,
      NULL,
      11,
      NULL,
      19.675280,
      1,
      NULL,
      6.170248,
      NULL,
      35.625577,
      NULL,
      NULL,
      43.057696,
      NULL,
      27,
      20.915661,
      21.003175,
      10,
      70,
      2,
      50.369059,
      8,
      142,
      24.749997,
      0.959107,
      58.600313,
      61,
      NULL,
      2.049045,
      7,
      192,
      ' 1- 6-1994',
      7,
      45.498716,
      NULL,
      30,
      193.411522,
      133.415265,
      ' 8- 2-1978',
      0,
      1.724561,
      0,
      1.642980,
      1,
      0,
      NULL,
      NULL,
      1.340914,
      0.613066,
      1,
      0.530088,
      1,
      1,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-25-1983',
      8.777083,
      2.768939,
      7,
      3,
      6.384974,
      2,
      ' 6- 1-2001',
      1.588509,
      NULL,
      132.432569,
      1,
      1,
      122.621638,
      1,
      NULL,
      103.301317,
      1,
      1.835345,
      138,
      ' 9- 9-1974',
      6,
      34.317842,
      56,
      12,
      84.186376,
      48.296413,
      62.570324,
      NULL,
      57.938488,
      8.855908,
      9,
      34,
      ' 2-28-1997',
      17.470924,
      18.680169,
      13,
      34,
      NULL,
      NULL,
      NULL,
      ' 1- 3-2002',
      10.033717,
      NULL,
      ' 0-17-1977',
      2,
      8,
      2,
      13,
      17.419890,
      0,
      0,
      5.165934,
      NULL,
      74,
      0.575935,
      NULL,
      5.289987,
      7.813403,
      0.592856,
      1.096334,
      NULL,
      0.819839,
      ' 6- 4-1981',
      0,
      0.321146,
      4,
      NULL,
      86.234302,
      NULL,
      ' 0- 1-1986',
      6.920634,
      12,
      '11- 5-1987',
      22.719875,
      '10- 4-1995',
      18.394100,
      ' 2-16-2003',
      3.636922,
      12,
      ' 2-23-1991',
      NULL,
      NULL,
      NULL,
      8,
      5.980147,
      ' 5-12-1974',
      NULL,
      3,
      '11-25-1994',
      0,
      1,
      3,
      ' 6- 4-1994',
      28,
      NULL,
      20,
      ' 3- 6-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.348708);
commit;
end;
/


