set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6902795';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3342',
      '01133324',
      '20212011',
      NULL,
      '33332220',
      '31114113',
      '04112113',
      '14211433',
      '00433010',
      '13412221',
      '01220303',
      '02434443',
      '21000304',
      NULL,
      '10201023',
      '30311411',
      NULL,
      '30143341',
      '20341340',
      '23341202',
      NULL,
      '21411224',
      NULL,
      '24411120',
      '33100340',
      '12433033',
      NULL,
      '03331422',
      '14014232',
      '22111100',
      '20142423',
      '32020430',
      '33014042',
      '41101421',
      '10243324',
      '12033224',
      '10432231',
      '10113401',
      NULL,
      '44440131',
      '24444324',
      '32202140',
      '24200422',
      '32412200',
      '20023140',
      '',
      '',
      NULL,
      NULL,
      '2104011',
      1.538897,
      0.291638,
      NULL,
      NULL,
      '000433',
      0,
      ' 2- 2-1999',
      ' 6-10-2001',
      NULL,
      NULL,
      3.881047,
      NULL,
      11,
      6.395154,
      20.387010,
      NULL,
      3,
      5.425368,
      15,
      1.648432,
      4,
      14,
      8,
      4,
      20.735345,
      6.091249,
      15,
      5.338080,
      1.405324,
      15.669467,
      20,
      7.449749,
      NULL,
      NULL,
      105,
      52.289456,
      91,
      50.086982,
      7.540862,
      NULL,
      12,
      6,
      8,
      NULL,
      NULL,
      27,
      ' 7-19-1977',
      4.084161,
      1.552055,
      NULL,
      0.524659,
      NULL,
      NULL,
      NULL,
      NULL,
      1.337330,
      NULL,
      0.311460,
      NULL,
      0.048861,
      0.527848,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10- 7-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-22-1974',
      6,
      NULL,
      79.112258,
      23.952806,
      NULL,
      80.551820,
      NULL,
      NULL,
      8.863642,
      83,
      2,
      11,
      ' 9- 5-1983',
      NULL,
      8,
      14,
      10,
      16.891010,
      0.085959,
      5,
      NULL,
      14,
      11,
      ' 0- 9-2003',
      1.440064,
      NULL,
      NULL,
      1.064300,
      NULL,
      6,
      NULL,
      5.767719,
      NULL,
      NULL,
      0,
      5,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-20-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      19.865802,
      39.570503,
      20,
      ' 2-13-2003',
      0,
      71,
      ' 2- 2-1987',
      3.796930,
      NULL,
      13.191662,
      NULL,
      ' 9-27-1996',
      47.317910,
      1,
      91,
      ' 5-21-1998',
      NULL,
      NULL,
      NULL,
      9.896577,
      NULL,
      6.884730,
      1.863411,
      21,
      124,
      46.102660,
      12,
      19.200180,
      27.855089,
      4,
      52.645324,
      NULL,
      3,
      80.334380,
      3.998878,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      21,
      1,
      16.519598,
      NULL,
      31,
      1,
      0.347804,
      NULL,
      0.137367,
      0.865446,
      0.289642,
      69,
      1.434915,
      72.188813,
      14,
      75,
      11.420518,
      3,
      0.721660,
      4,
      NULL,
      1,
      5.948731,
      23,
      NULL,
      45,
      0,
      15,
      0.839720,
      NULL,
      NULL,
      28,
      NULL,
      NULL,
      24,
      68,
      13,
      NULL,
      6.233259,
      6,
      2,
      8.943000,
      NULL,
      0.824444,
      NULL,
      NULL,
      NULL,
      ' 2- 4-1998',
      ' 8- 8-1994',
      NULL,
      ' 7-10-1985',
      ' 4- 8-1988',
      ' 0-25-1974',
      ' 0- 5-1994',
      NULL);
commit;
end;
/


